/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.assets;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.HangGlider;

public class WabItemGenerator
extends ItemModelProvider {
    public WabItemGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "wan_ancient_beasts", existingFileHelper);
    }

    protected void registerModels() {
        this.tool(WabItems.CHISEL);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.QUICK_SAND_BUCKET);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.QUICK_RED_SAND_BUCKET);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.EATER_TOOTH);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.CRUSHER_SPIKE);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.GLIDER_FEATHER);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.SURFER_ARMOR);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.ANCIENT_UPGRADE_SMITHING_TEMPLATE);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.FROZEN_ANCIENT_MEAT);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.RAW_ANCIENT_MEAT);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.COOKED_ANCIENT_MEAT);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.TOXLACANTH);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.COOKED_TOXLACANTH);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.TOXLACANTH_BUCKET);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.SNIFF_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.JAW_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.SPIKE_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.STROLL_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.BEAK_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.FALL_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.FOSSIL_POTTERY_SHERD);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabItems.TIDE_POTTERY_SHERD);
        this.spawnEgg(WabItems.EATER_SPAWN_EGG);
        this.spawnEgg(WabItems.WALKER_SPAWN_EGG);
        this.spawnEgg(WabItems.CRUSHER_SPAWN_EGG);
        this.spawnEgg(WabItems.GLIDER_SPAWN_EGG);
        this.spawnEgg(WabItems.SOARER_SPAWN_EGG);
        this.spawnEgg(WabItems.SURFER_SPAWN_EGG);
        this.spawnEgg(WabItems.PALEONTOLOGIST_SPAWN_EGG);
        this.spawnEgg(WabItems.TOXLACANTH_SPAWN_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.EATER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.WALKER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.CRUSHER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.GLIDER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.SOARER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.SURFER_EGG);
        this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)WabBlocks.NEST);
        this.block(WabBlocks.SUSPICIOUS_RED_SAND, this.blockResource("suspicious_red_sand_0"));
        this.block(WabBlocks.SUSPICIOUS_ICE, this.blockResource("suspicious_ice_0"));
        this.block(WabBlocks.FROZEN_STRAW_BLOCK);
        this.block(WabBlocks.STRAW_BLOCK);
        this.block(WabBlocks.STRAW_STAIRS);
        this.block(WabBlocks.STRAW_SLAB);
        this.block(WabBlocks.SNIFFER_SKULL);
        this.block(WabBlocks.EATER_SKULL);
        this.block(WabBlocks.WALKER_SKULL);
        this.block(WabBlocks.CRUSHER_SKULL);
        this.block(WabBlocks.GLIDER_SKULL);
        this.block(WabBlocks.SOARER_SKULL);
        this.block(WabBlocks.SURFER_SKULL);
        this.block(WabBlocks.CHARGER_SKULL);
        this.block(WabBlocks.RAIDER_SKULL);
        this.hangGlider(WabItems.HANG_GLIDER);
        this.hangGlider(WabItems.WHITE_HANG_GLIDER);
        this.hangGlider(WabItems.LIGHT_GRAY_HANG_GLIDER);
        this.hangGlider(WabItems.GRAY_HANG_GLIDER);
        this.hangGlider(WabItems.BLACK_HANG_GLIDER);
        this.hangGlider(WabItems.BROWN_HANG_GLIDER);
        this.hangGlider(WabItems.RED_HANG_GLIDER);
        this.hangGlider(WabItems.ORANGE_HANG_GLIDER);
        this.hangGlider(WabItems.YELLOW_HANG_GLIDER);
        this.hangGlider(WabItems.LIME_HANG_GLIDER);
        this.hangGlider(WabItems.GREEN_HANG_GLIDER);
        this.hangGlider(WabItems.LIGHT_BLUE_HANG_GLIDER);
        this.hangGlider(WabItems.CYAN_HANG_GLIDER);
        this.hangGlider(WabItems.BLUE_HANG_GLIDER);
        this.hangGlider(WabItems.PURPLE_HANG_GLIDER);
        this.hangGlider(WabItems.MAGENTA_HANG_GLIDER);
        this.hangGlider(WabItems.PINK_HANG_GLIDER);
    }

    public ItemModelBuilder basicItem(DeferredHolder<? extends ItemLike, ? extends ItemLike> item) {
        return this.basicItem(item, this.resource(item.getId().getPath()));
    }

    public ItemModelBuilder basicItem(DeferredHolder<? extends ItemLike, ? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", texture);
    }

    public ItemModelBuilder tool(DeferredItem<?> item) {
        return this.tool(item, this.resource(item.getId().getPath()));
    }

    public ItemModelBuilder tool(DeferredItem<?> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/handheld"))).texture("layer0", texture);
    }

    public ItemModelBuilder block(DeferredBlock<?> block) {
        return this.block(block, WanAncientBeasts.resource("block/" + block.getId().getPath()));
    }

    public ItemModelBuilder block(DeferredBlock<?> block, ResourceLocation parent) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().getPath(), parent);
    }

    public ItemModelBuilder spawnEgg(DeferredItem<SpawnEggItem> egg) {
        return (ItemModelBuilder)this.withExistingParent(egg.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
    }

    public ItemModelBuilder hangGlider(DeferredItem<HangGlider> hangGlider) {
        return this.basicItem((DeferredHolder<? extends ItemLike, ? extends ItemLike>)hangGlider).override().predicate(WanAncientBeasts.resource("hanging"), 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(this.resource(hangGlider.getId().getPath() + "_hanging"), this.existingFileHelper)).end();
    }

    private ResourceLocation resource(String name) {
        return WanAncientBeasts.resource("item/" + name);
    }

    private ResourceLocation blockResource(String name) {
        return WanAncientBeasts.resource("block/" + name);
    }
}

