/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class QuickSandAttachment {
    private long lastTick;
    private int ticks;
    public static final Codec<QuickSandAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("lastTick").forGetter(QuickSandAttachment::getLastTick), (App)Codec.INT.fieldOf("ticks").forGetter(QuickSandAttachment::getTicks)).apply((Applicative)instance, QuickSandAttachment::new));

    public QuickSandAttachment(long lastTick, int ticks) {
        this.lastTick = lastTick;
        this.ticks = ticks;
    }

    public void addTickInQuicksand(long tick) {
        this.ticks = Math.max(this.getTickInQuicksand(tick) + 2, 1);
        this.lastTick = tick;
    }

    public int getTickInQuicksand(long tick) {
        return this.ticks - Math.max((int)(tick - this.lastTick), 0);
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public int getTicks() {
        return this.ticks;
    }
}

