/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.event.setup;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.entity.Paleontologist;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.entity.Surfer;
import net.wanmine.wab.entity.Toxlacanth;
import net.wanmine.wab.entity.Walker;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.mixin.accessor.BlockEntityTypeAccessor;

@EventBusSubscriber(modid="wan_ancient_beasts")
public class CommonSetup {
    public static boolean checkAncientAnimalSpawnRules(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getBlockState(pPos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        WanAncientBeasts.LOGGER.info("Hello World from Wan's Ancient Beasts Common Side");
        HashSet<Block> brushableBlocks = new HashSet<Block>(((BlockEntityTypeAccessor)BlockEntityType.BRUSHABLE_BLOCK).wab$getValidBlocks());
        brushableBlocks.add((Block)WabBlocks.SUSPICIOUS_RED_SAND.get());
        ((BlockEntityTypeAccessor)BlockEntityType.BRUSHABLE_BLOCK).wab$setValidBlocks((Set<Block>)ImmutableSet.copyOf(brushableBlocks));
    }

    @SubscribeEvent
    public static void registerSpawns(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)WabEntities.EATER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CommonSetup::checkAncientAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.WALKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CommonSetup::checkAncientAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.CRUSHER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CommonSetup::checkAncientAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.GLIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CommonSetup::checkAncientAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.SOARER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CommonSetup::checkAncientAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.SURFER.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Surfer::checkSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.PALEONTOLOGIST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Paleontologist::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WabEntities.TOXLACANTH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Toxlacanth::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WabEntities.EATER.get(), Eater.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.WALKER.get(), Walker.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.CRUSHER.get(), Crusher.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.GLIDER.get(), Glider.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.SOARER.get(), Soarer.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.SURFER.get(), Surfer.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.PALEONTOLOGIST.get(), Paleontologist.getDefaultAttributes().build());
        event.put((EntityType)WabEntities.TOXLACANTH.get(), Toxlacanth.getDefaultAttributes().build());
    }
}

