/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.part;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class WabEntityPart<T extends LivingEntity>
extends PartEntity<T> {
    protected T mob;
    protected final float width;
    protected final float height;
    protected final float distance;
    protected final float relY;
    protected final float relAngle;

    public WabEntityPart(T mob, float width, float height, float distance, float relY) {
        this(mob, width, height, distance, relY, 0.0f);
    }

    public WabEntityPart(T mob, float width, float height, float distance, float relY, float relAngle) {
        super(mob);
        this.mob = mob;
        this.width = width;
        this.height = height;
        this.distance = distance;
        this.relY = relY;
        this.relAngle = relAngle;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.mob.getPickResult();
    }

    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source) && this.mob.hurt(source, amount);
    }

    public InteractionResult interact(Player p_19978_, InteractionHand p_19979_) {
        return this.mob.interact(p_19978_, p_19979_);
    }

    public boolean is(Entity entity) {
        return this == entity || this.mob == entity;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.width, (float)this.height);
    }

    public void update() {
        this.updatePos();
        this.updateBoundingBox();
    }

    public void updatePos() {
        Vec3 vec = new Vec3(this.getX(), this.getY(), this.getZ());
        this.setPos(this.mob.getX() + (double)this.getDistance() * Math.cos(Math.toRadians(this.getRotation() + this.relAngle + 90.0f)), this.mob.getY() + (double)this.getRelY(), this.mob.getZ() + (double)this.getDistance() * Math.sin(Math.toRadians(this.getRotation() + this.relAngle + 90.0f)));
        this.xo = vec.x;
        this.yo = vec.y;
        this.zo = vec.z;
        this.xOld = vec.x;
        this.yOld = vec.y;
        this.zOld = vec.z;
    }

    public void updateBoundingBox() {
        float width = this.getWidth();
        float height = this.getHeight();
        this.setBoundingBox(new AABB(this.getX() - (double)(width / 2.0f), this.getY(), this.getZ() - (double)(width / 2.0f), this.getX() + (double)(width / 2.0f), this.getY() + (double)height, this.getZ() + (double)(width / 2.0f)));
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public float getRotation() {
        return ((LivingEntity)this.mob).yBodyRot;
    }

    public float getWidth() {
        return this.mob.isBaby() ? this.width * 0.4f : this.width;
    }

    public float getHeight() {
        return this.mob.isBaby() ? this.height * 0.4f : this.height;
    }

    public float getDistance() {
        return this.mob.isBaby() ? this.distance * 0.4f : this.distance;
    }

    public float getRelY() {
        return this.mob.isBaby() ? this.relY * 0.4f : this.relY;
    }
}

