/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.wanmine.wab.entity.Walker;
import net.wanmine.wab.init.world.WabMenus;

public class WalkerInventoryMenu
extends AbstractContainerMenu {
    private final Container container;
    public final Walker walker;

    public WalkerInventoryMenu(int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        this(pContainerId, inventory, (Walker)inventory.player.level().getEntity(buf.readInt()));
    }

    public WalkerInventoryMenu(int pContainerId, Inventory pPlayerInventory, final Walker walker) {
        super((MenuType)WabMenus.WALKER_INVENTORY.get(), pContainerId);
        this.container = walker.getInventory();
        this.walker = walker;
        this.container.startOpen(pPlayerInventory.player);
        this.addSlot(new Slot(this, this.container, 0, 41, 16){

            public boolean mayPlace(ItemStack p_39677_) {
                return p_39677_.is(Items.SADDLE);
            }

            public boolean isActive() {
                return walker.isSaddleable();
            }
        });
        if (this.hasChest(walker)) {
            for (int k = 0; k < 7; ++k) {
                for (int l = 0; l < walker.getInventoryColumns(); ++l) {
                    this.addSlot(new Slot(this.container, 1 + l + k * walker.getInventoryColumns(), 90 + l * 18, 7 + k * 18));
                }
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot((Container)pPlayerInventory, k1 + i1 * 9 + 9, 36 + k1 * 18, 137 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot((Container)pPlayerInventory, j1, 36 + j1 * 18, 195));
        }
    }

    public boolean stillValid(Player player) {
        return !this.walker.hasInventoryChanged(this.container) && this.container.stillValid(player) && this.container.stillValid(player) && this.walker.isAlive() && player.canInteractWithEntity((Entity)this.walker, 4.0);
    }

    private boolean hasChest(Walker walker) {
        return walker.hasChest();
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int i = this.container.getContainerSize();
            if (pIndex < i) {
                if (!this.moveItemStackTo(itemstack1, i, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (i <= 2 || !this.moveItemStackTo(itemstack1, 2, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (pIndex >= j && pIndex < k ? !this.moveItemStackTo(itemstack1, i, j, false) : (pIndex >= i && pIndex < j ? !this.moveItemStackTo(itemstack1, j, k, false) : !this.moveItemStackTo(itemstack1, j, j, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.container.stopOpen(pPlayer);
    }
}

