/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.wanmine.wab.entity.Eater;

public class EaterAttackPlayerGoal
extends NearestAttackableTargetGoal<Player> {
    protected final Eater entity;

    public EaterAttackPlayerGoal(Eater entity, Class<Player> player, boolean mustSee) {
        super((Mob)entity, player, mustSee);
        this.entity = entity;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.entity.getRoared();
    }

    public boolean canUse() {
        if (!this.entity.isBaby() && super.canUse()) {
            for (Eater eater : this.entity.level().getEntitiesOfClass(Eater.class, this.entity.getBoundingBox().inflate(16.0, 8.0, 16.0))) {
                if (!eater.isBaby()) continue;
                return this.entity.getRoared();
            }
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.entity.setRoared(false);
    }

    protected double getFollowDistance() {
        return super.getFollowDistance() * 0.5;
    }
}

