/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.function.Predicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.goals.walker.WalkerBreedGoal;
import net.wanmine.wab.entity.goals.walker.WalkerPanicGoal;
import net.wanmine.wab.entity.inventory.WalkerInventoryMenu;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Walker
extends AbstractChestedHorse
implements PlayerRideableJumping,
Saddleable,
MenuProvider,
GeoEntity {
    public static final String ID = "walker";
    public static final String SPAWN_EGG_ID = "walker_spawn_egg";
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Walker.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WabEntityPart<Walker>[] subEntities;
    private final WabEntityPart<Walker> neck = new WabEntityPart<Walker>(this, 1.0f, 5.8f, 2.4f, 3.0f);
    private int tickLeft = 0;

    public Walker(EntityType<? extends AbstractChestedHorse> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.getNavigation();
        groundpathnavigation.setCanWalkOverFences(true);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.WALKER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)WabServerConfig.WALKER_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)WabServerConfig.WALKER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.WALKER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    protected void randomizeAttributes(RandomSource source) {
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.KNOCKBACK_RESISTANCE, 2.147483647E9).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.ARMOR, 10.0).add(Attributes.JUMP_STRENGTH, 0.1).add(Attributes.MOVEMENT_SPEED, 0.12);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WalkerPanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new WalkerBreedGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SPORE_BLOSSOM, Items.AZALEA_LEAVES, Items.FLOWERING_AZALEA_LEAVES}), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.WALKER.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.WALKER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == Items.AZALEA_LEAVES || stack.getItem() == Items.FLOWERING_AZALEA_LEAVES || stack.getItem() == Items.SPORE_BLOSSOM;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(Walker.walk(this));
        controller.add(Walker.baby(this));
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Walker> walk(Walker walker) {
        return new AnimationController((GeoAnimatable)walker, "walk", 1, state -> {
            if (walker.tickLeft <= 0) {
                if (walker.isMoving()) {
                    if (walker.isSprinting()) {
                        walker.setState(State.RUN);
                    } else {
                        walker.setState(State.WALK);
                    }
                } else {
                    walker.setState(State.IDLE);
                }
            }
            return state.setAndContinue(walker.getState().getAnimation());
        });
    }

    public void tick() {
        block4: {
            block3: {
                block5: {
                    super.tick();
                    if (!this.level().isClientSide) break block3;
                    if (this.tickLeft > 0) {
                        --this.tickLeft;
                    }
                    if (this.getState() == State.IDLE || this.isInWaterOrBubble()) break block4;
                    if (!this.isSprinting() || this.level().getGameTime() % 12L != 0L) break block5;
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.WALKER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    break block4;
                }
                if (this.level().getGameTime() % 15L != 0L) break block4;
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.WALKER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                break block4;
            }
            if (this.isSprinting() && this.level().getDayTime() % 10L == 0L) {
                for (LivingEntity target : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.7, 1.0, 3.7))) {
                    if (target instanceof Walker) continue;
                    target.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MOB_ATTACK)), 2.0f);
                }
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        for (WabEntityPart<Walker> part : this.subEntities) {
            part.update();
        }
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if ((state == State.WALK || state == State.RUN) && this.getState() == State.IDLE) {
            state = State.START_WALK;
        } else if (state == State.IDLE && (this.getState() == State.WALK || this.getState() == State.RUN)) {
            state = State.STOP_WALK;
        }
        this.tickLeft = state.getDuration();
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.getItem() == Items.SPORE_BLOSSOM) {
            if (this.isBaby() && !this.isTamed()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                if (this.random.nextInt(3) == 0) {
                    this.tameWithName(pPlayer);
                } else {
                    this.spawnTamingParticles(false);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.isBaby() && !this.isInLove()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.setInLove(pPlayer);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        } else if (itemstack.getItem() == Items.AZALEA_LEAVES || itemstack.getItem() == Items.FLOWERING_AZALEA_LEAVES) {
            if (this.isBaby()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.ageUp(Walker.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.heal(3.0f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        } else if (this.isTamed() && !this.isBaby()) {
            if (pPlayer.isSecondaryUseActive()) {
                this.openCustomInventoryScreen(pPlayer);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.hasChest() && itemstack.is(Items.CHEST)) {
                this.equipChest(pPlayer, itemstack);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getPassengers().size() < 4) {
                this.doPlayerRide(pPlayer);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    private void equipChest(Player player, ItemStack item) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!player.getAbilities().instabuild) {
            item.shrink(1);
        }
        this.createInventory();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((PlayerTrigger)WabTriggers.EQUIP_WALKER_CHEST.get()).trigger(serverPlayer);
        }
    }

    protected boolean canAddPassenger(Entity pPassenger) {
        return this.getPassengers().size() <= 4 && this.isTamed();
    }

    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        int i = this.getPassengers().indexOf(entity);
        if (i >= 0) {
            boolean flag = i == 0;
            double x = -0.75;
            double y = 3.85;
            double z = 0.5;
            if (!flag) {
                if (i == 1) {
                    x = 0.75;
                } else if (i == 2) {
                    y = 3.25;
                    z = -1.3;
                } else if (i == 3) {
                    x = 0.75;
                    y = 3.25;
                    z = -1.3;
                }
            }
            Vec3 vec3 = new Vec3(x, y, z).yRot(-this.yBodyRot * ((float)Math.PI / 180));
            moveFunction.accept(entity, this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
            this.clampRotation(entity);
        }
    }

    public void onPassengerTurned(Entity pEntityToUpdate) {
        if (this.getControllingPassenger() != pEntityToUpdate) {
            this.clampRotation(pEntityToUpdate);
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.setYBodyRot(this.getYRot());
        float f = pEntity.getYRot();
        float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
        float f2 = Mth.clamp((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.yRotO += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.setYRot(f3);
        pEntity.setYHeadRot(f3);
    }

    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (!this.getPassengers().isEmpty() && this.isSaddled() && (entity = (Entity)this.getPassengers().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dim, float p_299886_) {
        return new Vec3(0.0, 3.7, 0.0);
    }

    protected float getRiddenSpeed(Player player) {
        float f = player.isSprinting() ? 0.0f : -0.03f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f;
    }

    public boolean canSprint() {
        return true;
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public boolean canMate(Animal pOtherAnimal) {
        if (pOtherAnimal != this && pOtherAnimal instanceof Walker) {
            Walker walker = (Walker)pOtherAnimal;
            return this.canParent() && walker.canParent();
        }
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.isInLove();
    }

    public static int getInventorySize(int columns) {
        return columns * 7 + 1;
    }

    public int getInventoryColumns() {
        return 7;
    }

    public void openCustomInventoryScreen(Player player) {
        if (!this.level().isClientSide && (!this.isVehicle() || this.hasPassenger((Entity)player)) && this.isTamed()) {
            player.openMenu((MenuProvider)this, buf -> buf.writeInt(this.getId()));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new WalkerInventoryMenu(i, inventory, this);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public boolean canBeCollidedWith() {
        return !this.isBaby();
    }

    public boolean isMoving() {
        return this.getDeltaMovement().x != 0.0 || this.getDeltaMovement().z != 0.0;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)WabSounds.WALKER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.WALKER_HIT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)WabSounds.WALKER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle")),
        START_WALK(RawAnimation.begin().thenPlay("move.start_walk"), 18),
        WALK(RawAnimation.begin().thenPlay("move.walk")),
        RUN(RawAnimation.begin().thenPlay("move.run")),
        STOP_WALK(RawAnimation.begin().thenPlay("move.stop_walk"), 12);

        private final RawAnimation animation;
        private final int duration;

        private State(RawAnimation animation) {
            this.animation = animation;
            this.duration = 0;
        }

        private State(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

