/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabParticles;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Toxlacanth
extends AbstractFish
implements GeoEntity {
    public static final String ID = "toxlacanth";
    public static final String SPAWN_EGG_ID = "toxlacanth_spawn_egg";
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Toxlacanth.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation SWIM = RawAnimation.begin().thenPlay("move.swim");
    private static final RawAnimation GROUND_IDLE = RawAnimation.begin().thenPlay("misc.ground_idle");
    private static final RawAnimation TOXIC_GAS = RawAnimation.begin().thenPlay("attack.toxic_gas");
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int toxicGasTick = 0;

    public Toxlacanth(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 2;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public static boolean canSpawn(EntityType<? extends Toxlacanth> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        Holder biome = level.getBiome(pos);
        if (pos.getY() > 35 && !biome.is(WabTags.Biomes.TOXLACANTH_SPAWN)) {
            return false;
        }
        return level.getFluidState(pos).is(FluidTags.WATER);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(Toxlacanth.state(this));
    }

    private static AnimationController<Toxlacanth> state(Toxlacanth toxlacanth) {
        return new AnimationController((GeoAnimatable)toxlacanth, "state", 1, state -> {
            if (toxlacanth.isInWaterOrBubble()) {
                if (toxlacanth.toxicGasTick > 0) {
                    return state.setAndContinue(TOXIC_GAS);
                }
                return state.setAndContinue(SWIM);
            }
            return state.setAndContinue(GROUND_IDLE);
        });
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.toxicGasTick = this.hurtTime == 9 ? 15 : Math.max(0, this.toxicGasTick - 1);
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (super.hurt(pSource, pAmount) && this.getLastHurtByMob() != null) {
            if (pSource.getEntity() != null && this.isAlive()) {
                this.spawnVenom();
            }
            return true;
        }
        return false;
    }

    private void spawnVenom() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SQUID_SQUIRT, SoundSource.NEUTRAL, this.getSoundVolume(), this.getVoicePitch());
        Vec3 vec3 = this.rotateVector(new Vec3(0.0, 0.0, -1.0)).add(this.getX(), this.getY(), this.getZ());
        for (int i = 0; i < 6; ++i) {
            Vec3 vec31 = this.rotateVector(new Vec3((double)this.random.nextFloat() * 0.6 - 0.3, 0.0, (double)this.random.nextFloat() * 0.6 - 0.3));
            Vec3 vec32 = vec31.scale(1.0 + (double)(this.random.nextFloat() * 5.0f));
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)((SimpleParticleType)WabParticles.TOXLACANTH_SMOKE.get()), vec3.x, vec3.y + 0.5, vec3.z, 0, vec32.x, vec32.y, vec32.z, (double)0.1f);
        }
        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)vec3, (double)3.0, (double)3.0, (double)3.0))) {
            if (entity instanceof Toxlacanth || entity instanceof Soarer) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 500), (Entity)this);
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 300), (Entity)this);
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200), (Entity)this);
        }
    }

    private Vec3 rotateVector(Vec3 pVector) {
        return pVector.yRot(-this.yBodyRotO * ((float)Math.PI / 180));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)WabItems.TOXLACANTH_BUCKET.get());
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

