/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.wanmine.wab.block.AncientSkull;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.world.WabBlocks;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Paleontologist
extends AbstractVillager
implements GeoEntity {
    public static final String ID = "paleontologist";
    public static final String SPAWN_EGG_ID = "paleontologist_spawn_egg";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Paleontologist(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public static boolean checkSpawnRules(EntityType<? extends Paleontologist> paleontologist, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getBlockState(pPos.below()).is(BlockTags.VALID_SPAWN) && pLevel.getRawBrightness(pPos, 0) > 8;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Evoker.class, 12.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vindicator.class, 8.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pillager.class, 15.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Illusioner.class, 12.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 0.8f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean showProgressBar() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide) {
                if (this.getOffers().isEmpty()) {
                    return InteractionResult.CONSUME;
                }
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void notifyTrade(MerchantOffer offer) {
        Player player = this.getTradingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((PlayerTrigger)WabTriggers.PALEONTOLOGIST_TRADE.get()).trigger(player2);
        }
        super.notifyTrade(offer);
    }

    protected void updateTrades() {
        MerchantOffer skullOffer;
        MerchantOffers offers = this.getOffers();
        int commonTrade = 6;
        if (this.random.nextInt(4) == 0 && (!(skullOffer = this.getRandomTrade(WabTags.Items.ANCIENT_SKULL, 6, 5, 10)).getCostA().is(((AncientSkull)((Object)WabBlocks.CHARGER_SKULL.get())).asItem()) && !skullOffer.getCostA().is(((AncientSkull)((Object)WabBlocks.RAIDER_SKULL.get())).asItem()) || this.random.nextInt(3) == 0)) {
            offers.add((Object)skullOffer);
            --commonTrade;
        }
        if (this.random.nextInt(5) == 0) {
            offers.add((Object)this.getRandomTrade(WabTags.Items.ANCIENT_EGGS, 5, 2, 10));
            --commonTrade;
        } else if (this.random.nextInt(4) == 0) {
            offers.add((Object)this.getRandomTrade(WabTags.Items.PALEONTOLOGIST_RARE, 5, 4, 8));
            --commonTrade;
        }
        if (this.random.nextInt(2) == 0) {
            offers.add((Object)this.getRandomTrade(WabTags.Items.PALEONTOLOGIST_ITEMS, 4, 4, 8));
            --commonTrade;
        }
        offers.add((Object)this.getRandomTrade(WabTags.Items.PALEONTOLOGIST_TOOLS, 3, 5, 6));
        --commonTrade;
        offers.add((Object)this.getRandomTrade((TagKey<Item>)ItemTags.DECORATED_POT_SHERDS, 2, 12, 3));
        if (--commonTrade > 1) {
            offers.add((Object)this.getRandomTrade((TagKey<Item>)ItemTags.DECORATED_POT_SHERDS, 2, 12, 3));
            --commonTrade;
        }
        for (int i = 0; i < commonTrade; ++i) {
            offers.add((Object)this.getRandomTrade(WabTags.Items.PALEONTOLOGIST_COMMON, 1, 16, 3));
        }
        Collections.reverse(offers);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(DefaultAnimations.genericWalkRunIdleController((Entity)this));
    }

    public boolean removeWhenFarAway(double p_35886_) {
        return false;
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), 3 + this.random.nextInt(4)));
        }
    }

    protected MerchantOffer getRandomTrade(TagKey<Item> tag, int emeralds, int uses, int xp) {
        Optional<List> tagItems = BuiltInRegistries.ITEM.getTag(tag).map(t -> t.stream().toList());
        if (tagItems.isPresent() && !tagItems.get().isEmpty()) {
            List<Holder> itemList = tagItems.get().stream().filter(holder -> {
                Item item = (Item)holder.value();
                return item != Items.BARRIER && item != Items.LIGHT;
            }).toList();
            return this.getTrade((Item)itemList.get(this.random.nextInt(itemList.size())).value(), emeralds, uses, xp);
        }
        return this.getTrade(ItemStack.EMPTY, emeralds, uses, xp);
    }

    protected MerchantOffer getTrade(Item item, int emeralds, int uses, int xp) {
        return this.getTrade(new ItemStack((ItemLike)item), emeralds, uses, xp);
    }

    protected MerchantOffer getTrade(ItemStack stack, int emeralds, int uses, int xp) {
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, emeralds), stack, uses, xp, 0.02f);
    }

    protected SoundEvent getAmbientSound() {
        return this.isTrading() ? SoundEvents.WANDERING_TRADER_TRADE : SoundEvents.WANDERING_TRADER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_35870_) {
        return SoundEvents.WANDERING_TRADER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WANDERING_TRADER_DEATH;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

