/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.goals.fly.FlyFollowOwnerGoal;
import net.wanmine.wab.entity.goals.fly.FlyPanicGoal;
import net.wanmine.wab.entity.goals.fly.RandomFlyGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.WabEntityPartHead;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.network.bidirection.GliderPartyingPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Glider
extends TamableAnimal
implements FlyingAnimal,
GeoEntity {
    public static final String ID = "glider";
    public static final String SPAWN_EGG_ID = "glider_spawn_egg";
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Glider.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean partying;
    private int tickLeft = 0;
    private int flapTick = -1;
    private final WabEntityPart<Glider>[] subEntities;
    private final WabEntityPartHead<Glider> head = new WabEntityPartHead<Glider>(this, 0.6f, 1.1f, 0.8f, 0.3f);

    public Glider(EntityType<Glider> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.head};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.GLIDER_HEALTH.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.GLIDER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("partying", this.partying);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.partying = pCompound.getBoolean("partying");
    }

    public static boolean canSpawn(EntityType<? extends Glider> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Glider.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FlyPanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FlyFollowOwnerGoal(this, 1.0, 16.0f, 5.0f));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), false));
        this.goalSelector.addGoal(7, (Goal)new RandomFlyGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level world) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)pServerPlayer, (CustomPacketPayload)new GliderPartyingPacket(this.getId(), this.partying), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)WabEntities.GLIDER.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.GLIDER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == Items.SALMON;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Glider.state(this), Glider.baby(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Glider> state(Glider glider) {
        return new AnimationController((GeoAnimatable)glider, "state", 1, state -> {
            if (glider.tickLeft <= 0) {
                if (state.isMoving() && glider.isFlying()) {
                    glider.setState(State.FLY);
                } else if (glider.isPartying()) {
                    glider.setState(State.DANCE);
                } else if (glider.isInSittingPose()) {
                    glider.setState(State.SIT);
                } else {
                    glider.setState(State.IDLE);
                }
            }
            return state.setAndContinue(glider.getState().getAnimation());
        });
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if (state == State.FLY && this.getState().isIdle()) {
            state = State.START_FLYING;
        } else if (state.isIdle() && this.getState() == State.FLY) {
            state = State.STOP_FLYING;
        }
        if (state == State.FLY && this.getState() != State.FLY) {
            this.flapTick = 60;
        } else if (this.getState() != State.FLY) {
            this.flapTick = -1;
        }
        this.tickLeft = state.getDuration();
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.getState() == State.START_FLYING && this.tickLeft == State.START_FLYING.getDuration() - 15) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.GLIDER_FLAP_START.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            } else if (this.getState() == State.STOP_FLYING && this.tickLeft == State.STOP_FLYING.getDuration()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.GLIDER_LANDING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
            if (this.flapTick >= 0) {
                if (this.flapTick == 60 || this.flapTick == 30) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.GLIDER_FLAP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
                --this.flapTick;
                if (this.flapTick == 0) {
                    this.flapTick = 60;
                }
            }
            if (this.tickLeft > 0) {
                --this.tickLeft;
            }
        } else if (this.isPartying() && this.level().getGameTime() % 60L == 0L && this.random.nextInt(40) == 0) {
            ItemStack itemstack = new ItemStack((ItemLike)WabItems.GLIDER_FEATHER.get());
            ItemEntity itementity = new ItemEntity(this.level(), this.position().x, this.position().y, this.position().z, itemstack);
            itementity.setDefaultPickUpDelay();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WOOL_FALL, SoundSource.NEUTRAL, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    public void aiStep() {
        super.aiStep();
        for (WabEntityPart<Glider> part : this.subEntities) {
            part.update();
        }
    }

    public void setRecordPlayingNearby(BlockPos pPos, boolean pIsPartying) {
        this.partying = pIsPartying;
        PacketDistributor.sendToServer((CustomPacketPayload)new GliderPartyingPacket(this.getId(), this.partying), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPartying() {
        return this.partying;
    }

    public void setPartying(boolean partying) {
        this.partying = partying;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        return super.hurt(pSource, pAmount);
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.isTame() && itemstack.is(Items.PUFFERFISH)) {
            this.usePlayerItem(pPlayer, pHand, itemstack);
            if (!this.level().isClientSide) {
                if (this.random.nextInt(3) == 0) {
                    this.tame(pPlayer);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isFood(itemstack)) {
            if (this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.heal(2.0f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isBaby()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.ageUp(Glider.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.isBaby() && !this.isInLove()) {
                this.usePlayerItem(pPlayer, pHand, itemstack);
                this.setInLove(pPlayer);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isOwnedBy((LivingEntity)pPlayer)) {
            if (!this.level().isClientSide) {
                this.setOrderedToSit(!this.isOrderedToSit());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public boolean isFlying() {
        return !this.onGround() || this.getDeltaMovement().y != 0.0;
    }

    public boolean onClimbable() {
        return false;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)WabSounds.GLIDER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.GLIDER_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isFlying() ? null : (SoundEvent)WabSounds.GLIDER_IDLE.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle_ground"), true),
        SIT(RawAnimation.begin().thenPlay("misc.sit"), true),
        WALK(RawAnimation.begin().thenPlay("move.walk"), false),
        START_FLYING(RawAnimation.begin().thenPlay("move.start_flying"), false, 25),
        FLY(RawAnimation.begin().thenPlay("move.fly"), false),
        STOP_FLYING(RawAnimation.begin().thenPlay("move.landing"), false, 30),
        DANCE(RawAnimation.begin().thenPlay("misc.dance"), true);

        private final RawAnimation animation;
        private final boolean isIdle;
        private final int duration;

        private State(RawAnimation animation, boolean isIdle) {
            this.animation = animation;
            this.isIdle = isIdle;
            this.duration = 0;
        }

        private State(RawAnimation animation, boolean isIdle, int duration) {
            this.animation = animation;
            this.isIdle = isIdle;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

