/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabServerConfig;
import net.wanmine.wab.entity.goals.eater.EaterAttackPlayerGoal;
import net.wanmine.wab.entity.goals.eater.EaterBreedGoal;
import net.wanmine.wab.entity.goals.eater.EaterMeleeAttackGoal;
import net.wanmine.wab.entity.goals.eater.EaterSleepingGoal;
import net.wanmine.wab.entity.goals.eater.RoarFirstGoal;
import net.wanmine.wab.entity.goals.eater.SleepingCheckGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.WabEntityPartHead;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.item.ReinforcedShield;
import net.wanmine.wab.network.client.EaterAlphaPacket;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Eater
extends Animal
implements GeoEntity,
NeutralMob {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RawAnimation BITE = RawAnimation.begin().thenPlay("attack.bite");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("misc.sleep");
    private static final RawAnimation START_SLEEP = RawAnimation.begin().thenPlay("misc.start_sleep");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("misc.wake_up");
    private static final RawAnimation ROAR = RawAnimation.begin().thenPlay("attack.roar");
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> ROARED = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> NOM_COUNT = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SLEEPING_TIME = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> FUTURE_TARGET = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> ALPHA = SynchedEntityData.defineId(Eater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final WabEntityPart<Eater>[] subEntities;
    private final WabEntityPartHead<Eater> head = new WabEntityPartHead<Eater>(this, 1.3f, 1.4f, 2.0f, 1.5f);
    private final WabEntityPart<Eater> tail1 = new WabEntityPart<Eater>(this, 1.0f, 1.0f, 1.8f, 1.6f, 180.0f);
    private final WabEntityPart<Eater> tail2 = new WabEntityPart<Eater>(this, 1.0f, 1.0f, 2.8f, 1.4f, 180.0f);
    private final int NOM_COUNTER = 5;
    public int attackTick = -10;
    boolean isMoving = false;

    public Eater(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.head, this.tail1, this.tail2};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData groupData) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)WabServerConfig.EATER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)WabServerConfig.EATER_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)WabServerConfig.EATER_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)WabServerConfig.EATER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.setHealth(((Double)WabServerConfig.EATER_HEALTH.get()).floatValue());
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.7).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.ARMOR, 6.0).add(Attributes.ATTACK_DAMAGE, 30.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.FOLLOW_RANGE, 35.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROARED, (Object)false);
        builder.define(RUNNING, (Object)false);
        builder.define(STATE, (Object)0);
        builder.define(NOM_COUNT, (Object)0);
        builder.define(SLEEPING_TIME, (Object)-1);
        builder.define(FUTURE_TARGET, (Object)Integer.MIN_VALUE);
        builder.define(ALPHA, (Object)false);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EaterAlphaPacket(this.getId(), this.hasEffect((Holder)WabEffects.ALPHA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(WabTags.Items.EATER_FOOD);
    }

    protected void registerGoals() {
        super.registerGoals();
        if (this.getNomCount() < 10) {
            this.goalSelector.addGoal(0, (Goal)new SleepingCheckGoal(this, (Goal)new FloatGoal((Mob)this)));
            this.goalSelector.addGoal(4, (Goal)new SleepingCheckGoal(this, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4)));
            this.goalSelector.addGoal(6, (Goal)new SleepingCheckGoal(this, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f)));
            this.goalSelector.addGoal(7, (Goal)new SleepingCheckGoal(this, (Goal)new RandomLookAroundGoal((Mob)this)));
            this.goalSelector.addGoal(2, (Goal)new SleepingCheckGoal(this, new EaterBreedGoal(this, 0.5)));
            this.goalSelector.addGoal(3, (Goal)new SleepingCheckGoal(this, (Goal)new TemptGoal((PathfinderMob)this, 0.5, (Predicate)Ingredient.of(WabTags.Items.EATER_FOOD), false)));
            this.goalSelector.addGoal(5, (Goal)new SleepingCheckGoal(this, (Goal)new RoarFirstGoal(this, Player.class, true)));
            this.goalSelector.addGoal(2, (Goal)new SleepingCheckGoal(this, (Goal)new EaterAttackPlayerGoal(this, Player.class, true)));
            this.goalSelector.addGoal(4, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, entity -> !entity.isBaby())));
            this.goalSelector.addGoal(2, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, false, false)));
            this.goalSelector.addGoal(4, (Goal)new SleepingCheckGoal(this, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true, entity -> !entity.getType().is(WabTags.Entities.EATER_IGNORE))));
            this.goalSelector.addGoal(2, (Goal)new SleepingCheckGoal(this, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0])));
            this.goalSelector.addGoal(2, (Goal)new SleepingCheckGoal(this, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.1f, 32.0f)));
            this.goalSelector.addGoal(1, (Goal)new SleepingCheckGoal(this, (Goal)new EaterMeleeAttackGoal(this, 1.0, false)));
            this.goalSelector.addGoal(5, (Goal)new SleepingCheckGoal(this, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false)));
            this.goalSelector.addGoal(5, (Goal)new EaterSleepingGoal(this));
        }
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.EATER.get()).create((Level)level);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.getItem() == WabItems.RAW_ANCIENT_MEAT.get()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            this.usePlayerItem(pPlayer, pHand, itemstack);
            this.addEffect(new MobEffectInstance(WabEffects.ALPHA, 3600));
            Random random = new Random();
            if (random.nextInt(16) == 0) {
                pPlayer.addEffect(new MobEffectInstance(WabEffects.ALPHA, 3600));
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.EATER_EGG.get())).asItem());
        ItemEntity itementity = new ItemEntity((Level)level, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        level.addFreshEntity((Entity)itementity);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            this.attackTick = Math.max(this.attackTick - 1, -10);
            if (this.attackTick > 0 && this.isAlive()) {
                LivingEntity target = this.getTarget();
                if (this.attackTick == 33 || this.attackTick == 13) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.EATER_BITE.get(), SoundSource.NEUTRAL, this.getSoundVolume(), this.getVoicePitch());
                }
                if (target != null && target.isAlive() && (this.attackTick == 28 || this.attackTick == 8) && this.isWithinMeleeAttackRange(target)) {
                    this.swing(InteractionHand.MAIN_HAND);
                    this.doHurtTarget((Entity)target);
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        for (int k = 0; k < player.getInventory().offhand.size(); ++k) {
                            if (((ItemStack)player.getInventory().offhand.get(k)).isEmpty() || !(((ItemStack)player.getInventory().offhand.get(k)).getItem() instanceof ShieldItem) || ((ItemStack)player.getInventory().offhand.get(k)).getItem() instanceof ReinforcedShield) continue;
                            ((ItemStack)player.getInventory().offhand.get(k)).shrink(1);
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_BREAK, SoundSource.MASTER, this.getSoundVolume(), this.getVoicePitch());
                        }
                        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ShieldItem && !(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ReinforcedShield)) {
                            player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_BREAK, SoundSource.MASTER, this.getSoundVolume(), this.getVoicePitch());
                        }
                    }
                }
            } else if (this.attackTick == 0) {
                this.setState(State.IDLE);
            }
        } else if (this.isMoving && this.level().getGameTime() % 18L == 0L && !this.isInWaterOrBubble()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.EATER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        } else if (this.getRunning() && this.level().getGameTime() % 12L == 0L && !this.isInWaterOrBubble()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)WabSounds.EATER_STEP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void aiStep() {
        super.aiStep();
        for (WabEntityPart<Eater> part : this.subEntities) {
            part.update();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag) {
            if (this.random.nextInt(99) < 5) {
                this.spawnAtLocation((ItemLike)WabItems.EATER_TOOTH.get());
            }
            this.increaseNomCount();
            if (entity.getType().is(WabTags.Entities.ANCIENT_MOBS)) {
                this.addEffect(new MobEffectInstance(WabEffects.ALPHA, 3600));
            }
            if (entity instanceof Goat) {
                WabTriggers.triggerNearby(WabTriggers.NEAR_EATER_KILL_GOAT, entity, 32);
            }
        }
        return flag;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.wakeUp();
        return super.hurt(source, amount);
    }

    public void wakeUp() {
        if (this.shouldBeSleeping()) {
            this.setNomCount(0);
            this.setState(State.WAKE_UP);
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.head.getBoundingBox().inflate(1.0, 1.5, 1.0).intersects(entity.getBoundingBox());
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)WabSounds.EATER_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)WabSounds.EATER_HIT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isSleeping()) {
            return (SoundEvent)WabSounds.EATER_SLEEP.get();
        }
        if (this.getState() != State.ROAR || this.getState() != State.BITE) {
            return (SoundEvent)WabSounds.EATER_IDLE.get();
        }
        return null;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.clamp((int)((Integer)this.entityData.get(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    public boolean getRoared() {
        return (Boolean)this.entityData.get(ROARED);
    }

    public void setRoared(boolean roared) {
        this.entityData.set(ROARED, (Object)roared);
    }

    public boolean getRunning() {
        return (Boolean)this.entityData.get(RUNNING);
    }

    public void setRunning(boolean running) {
        this.entityData.set(RUNNING, (Object)running);
    }

    public void increaseNomCount() {
        this.setNomCount(this.getNomCount() + 1);
    }

    public void setNomCount(int nomCount) {
        this.entityData.set(NOM_COUNT, (Object)nomCount);
    }

    public int getNomCount() {
        return (Integer)this.entityData.get(NOM_COUNT);
    }

    public void setSleepingTime(int sleepingTime) {
        this.entityData.set(SLEEPING_TIME, (Object)sleepingTime);
    }

    public int getSleepingTime() {
        return (Integer)this.entityData.get(SLEEPING_TIME);
    }

    public void setAlpha(boolean alpha) {
        this.entityData.set(ALPHA, (Object)alpha);
    }

    public boolean isAlpha() {
        return (Boolean)this.entityData.get(ALPHA);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null && !this.isBaby()) {
            if (target instanceof Player || target.getType().is(EntityTypeTags.ILLAGER)) {
                this.entityData.set(FUTURE_TARGET, (Object)target.getId());
            } else {
                super.setTarget(target);
            }
        } else {
            super.setTarget(target);
        }
    }

    public void applyFutureTarget() {
        if ((Integer)this.entityData.get(FUTURE_TARGET) != Integer.MIN_VALUE) {
            super.setTarget((LivingEntity)this.level().getEntity(((Integer)this.entityData.get(FUTURE_TARGET)).intValue()));
            this.entityData.set(FUTURE_TARGET, (Object)Integer.MIN_VALUE);
        }
    }

    public boolean shouldRoar() {
        return (Integer)this.entityData.get(FUTURE_TARGET) != Integer.MIN_VALUE && this.getState() != State.WAKE_UP;
    }

    public boolean shouldBeSleeping() {
        return this.getNomCount() > 5;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(Eater.baby(this));
        controller.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controller.add(Eater.eaterRunAnimation(this, RUN));
        controller.add(new AnimationController[]{this.addAnimation(BITE, State.BITE), this.addAnimation(ROAR, State.ROAR), this.addAnimation(SLEEP, State.SLEEP), this.addAnimation(START_SLEEP, State.START_SLEEP), this.addAnimation(WAKE_UP, State.WAKE_UP)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.isBaby()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public static <T extends LivingEntity> AnimationController<T> eaterRunAnimation(T entity, RawAnimation runAnimation) {
        return new AnimationController(entity, "run", 1, state -> {
            if (entity instanceof Eater) {
                Eater eater = (Eater)entity;
                eater.isMoving = state.isMoving();
                if (eater.getRunning() && state.isMoving()) {
                    return state.setAndContinue(runAnimation);
                }
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private <T extends LivingEntity> AnimationController<?> addAnimation(RawAnimation animation, State animationState) {
        return new AnimationController((GeoAnimatable)this, animation.toString(), 0, state -> {
            if (this.getState() == animationState) {
                return state.setAndContinue(animation);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public void playerTouch(Player player) {
        if (this.shouldBeSleeping()) {
            this.wakeUp();
            this.setTarget((LivingEntity)player);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public boolean canBeCollidedWith() {
        return !this.isBaby();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int p_21673_) {
    }

    @org.jetbrains.annotations.Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@org.jetbrains.annotations.Nullable UUID p_21672_) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum State {
        IDLE,
        WALK,
        ROAR,
        BITE,
        START_SLEEP,
        SLEEP,
        WAKE_UP;

    }
}

