/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.init.data.WabDamageType;

public class CrusherSpike
extends DirectionalBlock {
    public static final MapCodec<CrusherSpike> CODEC = CrusherSpike.simpleCodec(CrusherSpike::new);
    protected static final VoxelShape[] AABB = new VoxelShape[]{Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)10.0), Block.box((double)6.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0)};

    public CrusherSpike(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placeContext.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return CrusherSpike.isValidPlaceableBlock(pLevel, pPos, (Direction)pState.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos)) {
            return pState;
        }
        pLevel.destroyBlock(pCurrentPos, true);
        return Blocks.AIR.defaultBlockState();
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pState.getValue((Property)FACING) == Direction.UP) {
            pEntity.causeFallDamage(pFallDistance + 2.0f, 2.0f, WabDamageType.damageSource((LevelReader)pLevel, WabDamageType.CRUSHER_SPIKE));
        } else {
            super.fallOn(pLevel, pState, pPos, pEntity, pFallDistance);
        }
    }

    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        super.entityInside(blockState, level, pos, entity);
        VoxelShape shape = blockState.getShape((BlockGetter)level, pos);
        AABB box = entity.getBoundingBox().inflate(0.001);
        if (shape.toAabbs().stream().map(aabb -> aabb.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).anyMatch(arg_0 -> ((AABB)box).intersects(arg_0))) {
            entity.hurt(WabDamageType.damageSource((LevelReader)level, WabDamageType.CRUSHER_SPIKE), 3.0f);
        }
    }

    public static boolean isValidPlaceableBlock(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        BlockPos blockpos = pPos.relative(pDir.getOpposite());
        return pLevel.getBlockState(blockpos).isFaceSturdy((BlockGetter)pLevel, blockpos, pDir);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABB[((Direction)pState.getValue((Property)FACING)).get3DDataValue()];
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public boolean isCollisionShapeFullBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    public boolean isPathfindable(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }
}

