/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.init.world.WabSounds;
import org.jetbrains.annotations.NotNull;

public class BeastEggBlock<T extends LivingEntity>
extends SnifferEggBlock {
    public static final VoxelShape EATER_EGG_SHAPE = Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)16.0, (double)15.0);
    public static final VoxelShape WALKER_EGG_SHAPE = Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    public static final VoxelShape CRUSHER_EGG_SHAPE = Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0);
    public static final VoxelShape GLIDER_EGG_SHAPE = Block.box((double)2.5, (double)0.0, (double)3.5, (double)13.5, (double)13.0, (double)12.5);
    public static final VoxelShape SOARER_EGG_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.5, (double)14.0, (double)16.0, (double)13.5);
    public static final VoxelShape SURFER_EGG_SHAPE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)15.0, (double)12.5);
    public final Supplier<EntityType<T>> beast;
    public final VoxelShape shape;

    public BeastEggBlock(Supplier<EntityType<T>> beast, VoxelShape shape, BlockBehaviour.Properties properties) {
        super(properties.strength(0.5f).sound(SoundType.METAL).noOcclusion());
        this.beast = beast;
        this.shape = shape;
    }

    public void tick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if (!this.isReadyToHatch(blockState)) {
            level.playSound((Player)null, pos, (SoundEvent)WabSounds.EGG_HATCHED.get(), SoundSource.BLOCKS, 0.7f, 0.9f + source.nextFloat() * 0.2f);
            level.setBlock(pos, (BlockState)blockState.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(blockState) + 1)), 2);
        } else {
            level.playSound((Player)null, pos, (SoundEvent)WabSounds.EGG_HATCHED.get(), SoundSource.BLOCKS, 0.7f, 0.9f + source.nextFloat() * 0.2f);
            level.destroyBlock(pos, false);
            LivingEntity entity = (LivingEntity)this.beast.get().create((Level)level);
            if (entity != null) {
                if (entity instanceof AgeableMob) {
                    AgeableMob mob = (AgeableMob)entity;
                    mob.setBaby(true);
                }
                Vec3 vec3 = pos.getCenter();
                entity.moveTo(vec3.x(), vec3.y(), vec3.z(), Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    private boolean isReadyToHatch(BlockState blockState) {
        return this.getHatchLevel(blockState) == 2;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockstate, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape;
    }
}

