/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import xerca.xercapaint.Mod;
import xerca.xercapaint.item.ItemCanvas;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.ExportPaintingPacket;

public class CommandExport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"paintexport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.paintExport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintExport(class_2168 stack, String name) {
        Mod.LOGGER.debug("Paint export called. name: {}", (Object)name);
        if (stack.method_9228() == null) {
            Mod.LOGGER.error("Command entity is not found");
            return 0;
        }
        class_1297 commander = stack.method_9228();
        if (!(commander instanceof class_3222)) {
            Mod.LOGGER.error("Command entity is not a player");
            return 0;
        }
        class_3222 player = (class_3222)commander;
        ExportPaintingPacket pack = new ExportPaintingPacket(name);
        ServerPlayNetworking.send((class_3222)player, (class_8710)pack);
        return 1;
    }

    public static boolean doExport(class_1657 player, String name) {
        String dir = "paintings";
        String filename = name + ".paint";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (class_1799 s : player.method_5877()) {
            if (!(s.method_7909() instanceof ItemCanvas)) continue;
            List pixels = (List)s.method_57824(Items.CANVAS_PIXELS);
            String canvasId = (String)s.method_57824(Items.CANVAS_ID);
            if (pixels == null || canvasId == null) continue;
            try {
                int version = (Integer)s.method_57825(Items.CANVAS_VERSION, (Object)1);
                int generation = (Integer)s.method_57825(Items.CANVAS_GENERATION, (Object)0);
                String title = (String)s.method_57824(Items.CANVAS_TITLE);
                String author = (String)s.method_57824(Items.CANVAS_AUTHOR);
                class_2487 tag = new class_2487();
                tag.method_10572("pixels", pixels);
                tag.method_10582("name", canvasId);
                tag.method_10569("v", version);
                tag.method_10569("generation", generation);
                tag.method_10567("ct", (byte)((ItemCanvas)s.method_7909()).getCanvasType().ordinal());
                if (title != null && author != null) {
                    tag.method_10582("title", title);
                    tag.method_10582("author", author);
                }
                class_2507.method_10630((class_2487)tag, (Path)Path.of(filepath, new String[0]));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

