/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BackpackTemplateStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedbackpacks_backpack_templates";
    private static final BackpackTemplateStorage clientStorageCopy = new BackpackTemplateStorage();
    private final Map<ResourceLocation, CompoundTag> backpackTemplates = new HashMap<ResourceLocation, CompoundTag>();

    private BackpackTemplateStorage() {
    }

    public static BackpackTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (BackpackTemplateStorage)storage.computeIfAbsent(new SavedData.Factory(BackpackTemplateStorage::new, BackpackTemplateStorage::load), SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static BackpackTemplateStorage load(CompoundTag nbt, HolderLookup.Provider registries) {
        BackpackTemplateStorage storage = new BackpackTemplateStorage();
        BackpackTemplateStorage.readBackpackTemplates(nbt, storage);
        return storage;
    }

    private static void readBackpackTemplates(CompoundTag nbt, BackpackTemplateStorage storage) {
        if (!nbt.contains("backpackTemplates")) {
            return;
        }
        ListTag list = nbt.getList("backpackTemplates", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            ResourceLocation templateName = ResourceLocation.parse((String)tag.getString("templateName"));
            CompoundTag contents = tag.getCompound("contents");
            storage.backpackTemplates.put(templateName, contents);
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        CompoundTag ret = new CompoundTag();
        this.writeBackpackTemplates(ret);
        return ret;
    }

    private void writeBackpackTemplates(CompoundTag ret) {
        if (this.backpackTemplates.isEmpty()) {
            return;
        }
        ListTag backpackTemplatesNbt = new ListTag();
        for (Map.Entry<ResourceLocation, CompoundTag> entry : this.backpackTemplates.entrySet()) {
            CompoundTag ret1 = new CompoundTag();
            ret1.putString("templateName", entry.getKey().toString());
            ret1.put("contents", (Tag)entry.getValue());
            backpackTemplatesNbt.add((Object)ret1);
        }
        ret.put("backpackTemplates", (Tag)backpackTemplatesNbt);
    }

    public Optional<CompoundTag> getBackpackTemplate(ResourceLocation templateName) {
        return Optional.ofNullable(this.backpackTemplates.get(templateName));
    }

    public void setBackpackTemplate(ResourceLocation templateName, CompoundTag contents) {
        this.backpackTemplates.put(templateName, contents);
        this.setDirty();
    }

    public void removeBackpackTemplate(ResourceLocation templateName) {
        this.backpackTemplates.remove(templateName);
        this.setDirty();
    }

    public Map<ResourceLocation, CompoundTag> getBackpackTemplates() {
        return this.backpackTemplates;
    }

    public static void onClientWorldLoad(LevelEvent.Load evt) {
        if (evt.getLevel().isClientSide()) {
            BackpackTemplateStorage.clientStorageCopy.backpackTemplates.clear();
        }
    }
}

