/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.generator;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import uk.kihira.playerrugs.common.RugRegistry;

@EventBusSubscriber(modid="playerrugs", bus=EventBusSubscriber.Bus.MOD)
public class DataCreator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new Loots(packOutput, lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Language(packOutput));
            generator.addProvider(true, (DataProvider)new BlockStates(packOutput, helper));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, helper));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput output, HolderLookup.Provider provider) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RugRegistry.PLAYER_RUG.get())).pattern(" P ").pattern("LLL").pattern("LLL").define(Character.valueOf('P'), (ItemLike)Items.PLAYER_HEAD).define(Character.valueOf('L'), Tags.Items.LEATHERS).unlockedBy("has_player_head", Recipes.has((ItemLike)Items.PLAYER_HEAD)).unlockedBy("has_leather", Recipes.has((TagKey)Tags.Items.LEATHERS)).save(output);
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK)), lookupProvider);
        }

        private static class Blocks
        extends BlockLootSubProvider {
            protected Blocks(HolderLookup.Provider provider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
            }

            protected void generate() {
                this.add((Block)RugRegistry.PLAYER_RUG.get(), block -> LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.PROFILE))))));
            }

            protected Iterable<Block> getKnownBlocks() {
                return RugRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "playerrugs", "en_us");
        }

        protected void addTranslations() {
            this.add((Block)RugRegistry.PLAYER_RUG.get(), "Player Rug");
            this.add("playerrugs.tooltip", "Player: %s");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "playerrugs", helper);
        }

        protected void registerStatesAndModels() {
            this.makeState((DeferredHolder<Block, ? extends Block>)RugRegistry.PLAYER_RUG);
        }

        private void makeState(DeferredHolder<Block, ? extends Block> registryObject) {
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc(registryObject.getId().getPath()));
            this.getVariantBuilder((Block)registryObject.get()).forAllStates(arg_0 -> BlockStates.lambda$makeState$0((ModelFile)model, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeState$0(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "playerrugs", helper);
        }

        protected void registerModels() {
            this.makeUnchecked((DeferredHolder<Block, ? extends Block>)RugRegistry.PLAYER_RUG);
        }

        private void makeUnchecked(DeferredHolder<Block, ? extends Block> registryObject) {
            String path = registryObject.getId().getPath();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String getName() {
            return "Item Models";
        }
    }
}

