/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.common.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import uk.kihira.playerrugs.client.renderer.PlayerRugInventoryRenderer;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;

public class PlayerRugItem
extends BlockItem {
    public PlayerRugItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ResolvableProfile resolvableprofile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (!(resolvableprofile == null || resolvableprofile.isResolved() && resolvableprofile.properties().containsKey((Object)"textures"))) {
            PlayerRugBlockEntity.resolve(resolvableprofile).thenAcceptAsync(profile -> stack.set(DataComponents.PROFILE, profile), PlayerRugBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new PlayerRugInventoryRenderer(new BlockEntityRendererProvider.Context(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getBlockRenderer(), Minecraft.getInstance().getItemRenderer(), Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), Minecraft.getInstance().font));
            }
        });
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ResolvableProfile profile;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        MutableComponent playerComponent = Component.translatable((String)"playerrugs.tooltip", (Object[])new Object[]{Component.literal((String)"None").withStyle(ChatFormatting.RED)});
        if (stack.has(DataComponents.PROFILE) && (profile = (ResolvableProfile)stack.get(DataComponents.PROFILE)) != null && profile.name().isPresent()) {
            playerComponent = Component.translatable((String)"playerrugs.tooltip", (Object[])new Object[]{Component.literal((String)((String)profile.name().get())).withStyle(ChatFormatting.YELLOW)});
        }
        tooltipComponents.add((Component)playerComponent);
    }
}

