/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.common.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import uk.kihira.playerrugs.PlayerRugs;

public class RugConfig {
    public static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        PlayerRugs.LOGGER.debug("Loaded Player Rugs' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        PlayerRugs.LOGGER.debug("Player Rugs' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue easyCrafting;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.easyCrafting = builder.comment("If true, allows rugs to be renamed in anvils to get that players rug").define("easyCrafting", false);
            builder.pop();
        }
    }
}

