/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.common.blockentity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.serialization.DynamicOps;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.Services;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import uk.kihira.playerrugs.PlayerRugs;
import uk.kihira.playerrugs.common.RugRegistry;

public class PlayerRugBlockEntity
extends BlockEntity {
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @Nullable
    private static LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> profileCacheById;
    public static final Executor CHECKED_MAIN_THREAD_EXECUTOR;
    @Nullable
    private ResolvableProfile playerProfile;

    public PlayerRugBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RugRegistry.PLAYER_RUG_BLOCK_ENTITY.get(), pos, state);
    }

    public static void setup(final Services services, Executor p_mainThreadExecutor) {
        mainThreadExecutor = p_mainThreadExecutor;
        final BooleanSupplier booleansupplier = () -> profileCacheById == null;
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(String username) {
                return PlayerRugBlockEntity.fetchProfileByName(username, services);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(UUID id) {
                return PlayerRugBlockEntity.fetchProfileById(id, services, booleansupplier);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileByName(String name, Services services) {
        return services.profileCache().getAsync(name).thenCompose(optionalProfile -> {
            LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
            return loadingcache != null && !optionalProfile.isEmpty() ? ((CompletableFuture)loadingcache.getUnchecked((Object)((GameProfile)optionalProfile.get()).getId())).thenApply(profile -> profile.or(() -> optionalProfile)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(UUID id, Services services, BooleanSupplier cacheUninitialized) {
        return CompletableFuture.supplyAsync(() -> {
            if (cacheUninitialized.getAsBoolean()) {
                return Optional.empty();
            }
            ProfileResult profileresult = services.sessionService().fetchProfile(id, true);
            return Optional.ofNullable(profileresult).map(ProfileResult::profile);
        }, Util.backgroundExecutor());
    }

    public static void clear() {
        mainThreadExecutor = null;
        profileCacheByName = null;
        profileCacheById = null;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (compound.contains("profile")) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("profile")).resultOrPartial(error -> PlayerRugs.LOGGER.error("Failed to load profile from player rug: {}", error)).ifPresent(this::setPlayerProfile);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (this.playerProfile != null) {
            compound.put("profile", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.playerProfile).getOrThrow());
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.setPlayerProfile((ResolvableProfile)input.get(DataComponents.PROFILE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.PROFILE, (Object)this.playerProfile);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("profile");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag compoundNBT = pkt.getTag();
        this.handleUpdateTag(compoundNBT, lookupProvider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, lookupProvider);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)(this.level != null ? this.level.registryAccess() : VanillaRegistries.createLookup()));
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public ResolvableProfile getPlayerProfile() {
        return this.playerProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable ResolvableProfile profile) {
        PlayerRugBlockEntity playerRugBlockEntity = this;
        synchronized (playerRugBlockEntity) {
            this.playerProfile = profile;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.playerProfile != null && !this.playerProfile.isResolved()) {
            PlayerRugBlockEntity.resolve(this.playerProfile).thenAcceptAsync(profile -> {
                this.playerProfile = profile;
                this.setChanged();
            }, CHECKED_MAIN_THREAD_EXECUTOR);
        } else {
            this.setChanged();
        }
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String profileName) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheByName;
        return loadingcache != null && StringUtil.isValidPlayerName((String)profileName) ? (CompletableFuture)loadingcache.getUnchecked((Object)profileName) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID profileUuid) {
        LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
        return loadingcache != null ? (CompletableFuture)loadingcache.getUnchecked((Object)profileUuid) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<ResolvableProfile> resolve(ResolvableProfile resolvableProfile) {
        if (resolvableProfile.isResolved()) {
            return CompletableFuture.completedFuture(resolvableProfile);
        }
        return resolvableProfile.id().isPresent() ? PlayerRugBlockEntity.fetchGameProfile((UUID)resolvableProfile.id().get()).thenApply(profile -> {
            GameProfile gameprofile = profile.orElseGet(() -> new GameProfile((UUID)resolvableProfile.id().get(), resolvableProfile.name().orElse("")));
            return new ResolvableProfile(gameprofile);
        }) : PlayerRugBlockEntity.fetchGameProfile((String)resolvableProfile.name().orElseThrow()).thenApply(profile -> {
            GameProfile gameprofile = profile.orElseGet(() -> new GameProfile(Util.NIL_UUID, (String)resolvableProfile.name().get()));
            return new ResolvableProfile(gameprofile);
        });
    }

    static {
        CHECKED_MAIN_THREAD_EXECUTOR = runnable -> {
            Executor executor = mainThreadExecutor;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

