/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import uk.kihira.playerrugs.common.RugRegistry;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;

public class PlayerRugBlock
extends BaseEntityBlock {
    public static final MapCodec<PlayerRugBlock> CODEC = PlayerRugBlock.simpleCodec(PlayerRugBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty STANDING = BooleanProperty.create((String)"standing");
    private static final VoxelShape STANDING_EAST = Block.box((double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0);
    private static final VoxelShape STANDING_WEST = Block.box((double)15.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape STANDING_NORTH = Block.box((double)4.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape STANDING_SOUTH = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)1.0);
    private static final VoxelShape FACING_NORTH_SOUTH = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)16.0);
    private static final VoxelShape FACING_EAST_WEST = Block.box((double)1.0, (double)0.0, (double)4.0, (double)16.0, (double)1.0, (double)12.0);

    public PlayerRugBlock(BlockBehaviour.Properties builder) {
        super(builder.noCollission().isViewBlocking(PlayerRugBlock::never));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STANDING, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private static boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)STANDING)).booleanValue()) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return STANDING_NORTH;
                }
                case SOUTH: {
                    return STANDING_SOUTH;
                }
                case WEST: {
                    return STANDING_WEST;
                }
                case EAST: {
                    return STANDING_EAST;
                }
            }
        }
        return ((Direction)state.getValue((Property)FACING)).get2DDataValue() % 2 != 0 ? FACING_EAST_WEST : FACING_NORTH_SOUTH;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(level, pos, state);
        level.getBlockEntity(pos, (BlockEntityType)RugRegistry.PLAYER_RUG_BLOCK_ENTITY.get()).ifPresent(blockEntity -> blockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess()));
        return itemstack;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)STANDING, (Comparable)Boolean.valueOf(context.getClickedFace().getAxis().isHorizontal()));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STANDING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PlayerRugBlockEntity(pos, state);
    }
}

