/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.common;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import uk.kihira.playerrugs.common.RugRegistry;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;
import uk.kihira.playerrugs.common.item.PlayerRugItem;

public class PlayerRugCommand {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"playerrug");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(PlayerRugCommand::giveRug));
        dispatcher.register(root);
    }

    private static int giveRug(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String username = StringArgumentType.getString(ctx, (String)"name");
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            PlayerRugBlockEntity.fetchGameProfile(StringUtil.isValidPlayerName((String)username) ? username : player.getGameProfile().getName()).thenAccept(profile -> {
                if (profile.isPresent()) {
                    ItemStack newRug = ((PlayerRugItem)((Object)((Object)RugRegistry.PLAYER_RUG_ITEM.get()))).getDefaultInstance();
                    newRug.set(DataComponents.PROFILE, (Object)new ResolvableProfile((GameProfile)profile.get()));
                    player.addItem(newRug);
                }
            });
        }
        return 0;
    }
}

