/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import uk.kihira.playerrugs.client.renderer.PlayerRugBER;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;

public class PlayerRugInventoryRenderer
extends BlockEntityWithoutLevelRenderer {
    public final SkullModel headModel;
    public boolean isSlim = false;

    public PlayerRugInventoryRenderer(BlockEntityRendererProvider.Context context) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.headModel = new SkullModel(context.bakeLayer(ModelLayers.PLAYER_HEAD));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!stack.isEmpty()) {
            ResolvableProfile resolvableProfile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
            if (resolvableProfile != null && !resolvableProfile.isResolved()) {
                stack.remove(DataComponents.PROFILE);
                PlayerRugBlockEntity.resolve(resolvableProfile).thenAcceptAsync(profile -> stack.set(DataComponents.PROFILE, profile), (Executor)Minecraft.getInstance());
            }
            SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
            if (resolvableProfile != null && this.isSlim != skinmanager.getInsecureSkin(resolvableProfile.gameProfile()).model().id().equals("slim")) {
                this.isSlim = !this.isSlim;
            }
            poseStack.pushPose();
            poseStack.translate(0.1875, 0.1875, 0.5);
            if (type == ItemDisplayContext.GUI) {
                poseStack.mulPose(Axis.XN.rotationDegrees(-45.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0, 0.75, 0.0);
            }
            if (type == ItemDisplayContext.GROUND) {
                poseStack.translate(0.0625, 0.0, -0.25);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0, 0.25, 0.0);
            }
            if (type == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                poseStack.mulPose(Axis.XN.rotationDegrees(-15.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(15.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.375f, 1.0f, 0.0f);
            }
            if (type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                poseStack.mulPose(Axis.XN.rotationDegrees(-15.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(-15.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0f, 1.0f, -0.375f);
            }
            if (type == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                poseStack.mulPose(Axis.XN.rotationDegrees(-90.0f));
                poseStack.translate(-0.0625f, -0.0625f, -0.625f);
            }
            if (type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                poseStack.mulPose(Axis.XN.rotationDegrees(-90.0f));
                poseStack.translate(-0.0625f, -0.0625f, -0.625f);
            }
            if (type == ItemDisplayContext.FIXED) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(1.125f, 1.125f, 0.125f);
                poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            PlayerRugBER.renderRug(Direction.NORTH, resolvableProfile, this.isSlim, false, poseStack, buffer, packedLight, this.headModel);
            poseStack.popPose();
        }
    }
}

