/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import uk.kihira.playerrugs.client.renderer.PRRenderType;
import uk.kihira.playerrugs.common.block.PlayerRugBlock;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;

public class PlayerRugBER
implements BlockEntityRenderer<PlayerRugBlockEntity> {
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.getDefaultTexture();
    public final SkullModel headModel;
    public boolean isSlim = false;

    public PlayerRugBER(BlockEntityRendererProvider.Context context) {
        this.headModel = new SkullModel(context.bakeLayer(ModelLayers.PLAYER_HEAD));
    }

    public void render(PlayerRugBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        SkinManager skinmanager;
        BlockState blockstate = blockEntity.getBlockState();
        boolean flag = blockstate.getBlock() instanceof PlayerRugBlock;
        Direction direction = flag ? (Direction)blockstate.getValue((Property)PlayerRugBlock.FACING) : Direction.UP;
        ResolvableProfile resolvableProfile = blockEntity.getPlayerProfile();
        if (resolvableProfile != null && this.isSlim != (skinmanager = Minecraft.getInstance().getSkinManager()).getInsecureSkin(resolvableProfile.gameProfile()).model().id().equals("slim")) {
            this.isSlim = !this.isSlim;
        }
        boolean standing = (Boolean)blockstate.getValue((Property)PlayerRugBlock.STANDING);
        PlayerRugBER.renderRug(direction, resolvableProfile, this.isSlim, standing, poseStack, buffer, packedLight, this.headModel);
    }

    public static void renderRug(Direction direction, @Nullable ResolvableProfile resolvableProfile, boolean slim, boolean standing, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, SkullModel model) {
        poseStack.translate(0.5, 0.001, 0.5);
        poseStack.pushPose();
        poseStack.translate(0.0f, standing ? 0.4999f : 0.0f, 0.0f);
        float angle = (float)(direction.get2DDataValue() + 2) * -90.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        poseStack.translate(0.0, -0.001, standing ? 0.5 : -0.5625);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        RenderType headType = PlayerRugBER.getRenderType(resolvableProfile);
        VertexConsumer buffer = bufferSource.getBuffer(headType);
        model.renderToBuffer(poseStack, buffer, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        if (standing) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(0.0f, 0.4375f, -0.0625f);
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource1 = (MultiBufferSource.BufferSource)bufferSource;
            bufferSource1.endBatch(headType);
        }
        RenderType rugType = PRRenderType.playerRug(PlayerRugBER.getSkinLocation(resolvableProfile));
        VertexConsumer builder = bufferSource.getBuffer(rugType);
        float texHeight = 64.0f;
        float texWidth = 64.0f;
        float xOffset = -0.25f;
        float zOffset = -0.1875f;
        float thickness = 0.0625f;
        float yOffset = 0.0625f;
        if (standing) {
            xOffset = -0.5f;
            zOffset = -0.4375f;
            PlayerRugBER.buildBodyPart(builder, poseStack, xOffset + (slim ? 0.0625f : 0.0f), yOffset, zOffset, (slim ? 3.0f : 4.0f) / 16.0f, thickness, 0.75f, (slim ? 39.0f : 40.0f) / texWidth, 52.0f / texHeight, 36.0f / texWidth, 64.0f / texHeight, texWidth, texHeight, combinedLight);
        } else {
            PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset - (slim ? 0.0625f : 0.0f), -0.75f, thickness, -(slim ? 3.0f : 4.0f) / 16.0f, (slim ? 46.0f : 48.0f) / texWidth, 52.0f / texHeight, (slim ? 43.0f : 44.0f) / texWidth, 64.0f / texHeight, texWidth, texHeight, combinedLight);
        }
        xOffset = 0.25f;
        zOffset = -0.4375f;
        if (standing) {
            PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset, (slim ? 3.0f : 4.0f) / 16.0f, thickness, 0.75f, (slim ? 47.0f : 48.0f) / texWidth, 20.0f / texHeight, 44.0f / texWidth, 32.0f / texHeight, texWidth, texHeight, combinedLight);
        } else {
            PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset, 0.75f, thickness, (slim ? 3.0f : 4.0f) / 16.0f, (slim ? 54.0f : 56.0f) / texWidth, 20.0f / texHeight, (slim ? 51.0f : 52.0f) / texWidth, 32.0f / texHeight, texWidth, texHeight, combinedLight);
        }
        xOffset = -0.25f;
        zOffset = -0.4375f;
        PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset, 0.5f, thickness, 0.75f, (standing ? 28.0f : 32.0f) / texWidth, 20.0f / texHeight, (standing ? 20.0f : 40.0f) / texWidth, 32.0f / texHeight, texWidth, texHeight, combinedLight);
        xOffset = -0.25f;
        zOffset = 0.3125f;
        PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset, 0.25f, thickness, 0.75f, (standing ? 20.0f : 28.0f) / texWidth, 52.0f / texHeight, (standing ? 24.0f : 32.0f) / texWidth, 64.0f / texHeight, texWidth, texHeight, combinedLight);
        xOffset = 0.0f;
        zOffset = 0.3125f;
        PlayerRugBER.buildBodyPart(builder, poseStack, xOffset, yOffset, zOffset, 0.25f, thickness, 0.75f, (standing ? 4.0f : 12.0f) / texWidth, 20.0f / texHeight, (standing ? 8.0f : 16.0f) / texWidth, 32.0f / texHeight, texWidth, texHeight, combinedLight);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource1 = (MultiBufferSource.BufferSource)bufferSource;
            bufferSource1.endBatch(rugType);
        }
        poseStack.popPose();
    }

    public static RenderType getRenderType(@Nullable ResolvableProfile resolvableProfile) {
        return RenderType.entityTranslucent((ResourceLocation)PlayerRugBER.getSkinLocation(resolvableProfile));
    }

    public static ResourceLocation getSkinLocation(@Nullable ResolvableProfile resolvableProfile) {
        if (resolvableProfile == null) {
            return defaultTexture;
        }
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        return skinmanager.getInsecureSkin(resolvableProfile.gameProfile()).texture();
    }

    public static void buildBodyPart(VertexConsumer builder, PoseStack poseStack, float xPos, float yPos, float zPos, float width, float depth, float length, float minU, float minV, float maxU, float maxV, float texWidth, float texHeight, int combinedLight) {
        PoseStack.Pose pose = poseStack.last();
        Vec3i downVec = Direction.DOWN.getNormal();
        Vec3i upVec = Direction.UP.getNormal();
        Vec3i northVec = Direction.NORTH.getNormal();
        Vec3i southVec = Direction.SOUTH.getNormal();
        Vec3i westVec = Direction.WEST.getNormal();
        Vec3i eastVec = Direction.EAST.getNormal();
        float texDepth = depth * 16.0f;
        if (Math.abs(width) > Math.abs(length)) {
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, minU, minV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, maxU, minV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU, maxV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, minU, maxV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, minU, maxV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, maxU, maxV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, maxU, minV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV + texDepth / texHeight, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, maxU, minV + texDepth / texHeight, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, maxU, minV, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, minU, minV, combinedLight, northVec);
            float uUpper = maxU + (minU > maxU ? texDepth / texWidth : -(texDepth / texWidth));
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, uUpper, minV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, uUpper, maxV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU, maxV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, maxU, minV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, maxU, maxV - texDepth / texHeight, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, minU, maxV - texDepth / texHeight, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, minU, maxV, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU, maxV, combinedLight, southVec);
            uUpper = minU + (minU < maxU ? texDepth / texWidth : -(texDepth / texWidth));
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, minU, maxV, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, uUpper, minV, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, uUpper, maxV, combinedLight, westVec);
        } else {
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, minU, minV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, minU, maxV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU, maxV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, maxU, minV, combinedLight, upVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, maxU, minV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, maxU, maxV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, minU, maxV, combinedLight, downVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV, combinedLight, downVec);
            float uUpper = minU + (minU < maxU ? texDepth / texWidth : -(texDepth / texWidth));
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, minU, maxV, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, uUpper, maxV, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, uUpper, minV, combinedLight, northVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos + length, minU, maxV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, maxU, maxV, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU, maxV - texDepth / texHeight, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos + length, minU, maxV - texDepth / texHeight, combinedLight, eastVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos + length, maxU, maxV, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, maxU, minV, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, maxU - texDepth / texWidth, minV, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos + length, maxU - texDepth / texWidth, maxV, combinedLight, southVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos - depth, zPos, maxU, minV, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos - depth, zPos, minU, minV, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos, yPos, zPos, minU, minV + texDepth / texHeight, combinedLight, westVec);
            PlayerRugBER.addVertexWithUV(builder, pose, xPos + width, yPos, zPos, maxU, minV + texDepth / texHeight, combinedLight, westVec);
        }
    }

    private static void addVertexWithUV(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, int combinedLight, Vec3i directionVec) {
        Matrix4f matrix4f = pose.pose();
        builder.addVertex(matrix4f, x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)directionVec.getX(), (float)directionVec.getY(), (float)directionVec.getZ());
    }
}

