/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.playerrugs.client;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.server.Services;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import uk.kihira.playerrugs.client.renderer.PlayerRugBER;
import uk.kihira.playerrugs.common.RugRegistry;
import uk.kihira.playerrugs.common.blockentity.PlayerRugBlockEntity;

public class ClientHandler {
    public static void registerRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RugRegistry.PLAYER_RUG_BLOCK_ENTITY.get(), PlayerRugBER::new);
    }

    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isLocalServer()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    public static void onRespawn(ClientPlayerNetworkEvent.Clone event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isLocalServer()) {
            ClientHandler.setPlayerCache(mc);
        }
    }

    private static void setPlayerCache(Minecraft mc) {
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(mc.getProxy());
        Services services = Services.create((YggdrasilAuthenticationService)authenticationService, (File)mc.gameDirectory);
        services.profileCache().setExecutor((Executor)mc);
        PlayerRugBlockEntity.setup(services, (Executor)mc);
        GameProfileCache.setUsesAuthentication((boolean)false);
    }

    public static void onUnload(LevelEvent.Unload event) {
        PlayerRugBlockEntity.clear();
    }
}

