/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import uwu.juni.wetland_whimsy.WetlandWhimsy;

@ParametersAreNonnullByDefault
public record EnvironmentBiomeModifier(HolderSet<Biome> biomes, Optional<Integer> newFogColor, Optional<Integer> newSkyColor, Optional<Integer> newWaterColor, Optional<Integer> newWaterFogColor, Optional<Integer> newGrassColorOverride, Optional<Integer> newFoliageColorOverride, Optional<BiomeSpecialEffects.GrassColorModifier> newGrassModifier) implements BiomeModifier
{
    public static MapCodec<EnvironmentBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(EnvironmentBiomeModifier::biomes), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_fog_color", Optional.empty()).forGetter(EnvironmentBiomeModifier::newFogColor), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_sky_color", Optional.empty()).forGetter(EnvironmentBiomeModifier::newSkyColor), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_water_color", Optional.empty()).forGetter(EnvironmentBiomeModifier::newWaterColor), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_water_fog_color", Optional.empty()).forGetter(EnvironmentBiomeModifier::newWaterFogColor), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_grass_color_override", Optional.empty()).forGetter(EnvironmentBiomeModifier::newGrassColorOverride), (App)ExtraCodecs.optionalEmptyMap((Codec)Codec.INT).optionalFieldOf("new_foliage_color_override", Optional.empty()).forGetter(EnvironmentBiomeModifier::newFoliageColorOverride), (App)ExtraCodecs.optionalEmptyMap((Codec)BiomeSpecialEffects.GrassColorModifier.CODEC).optionalFieldOf("new_grass_color_modifier", Optional.empty()).forGetter(EnvironmentBiomeModifier::newGrassModifier)).apply((Applicative)instance, EnvironmentBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!this.biomes.contains(biome) || !phase.equals((Object)BiomeModifier.Phase.BEFORE_EVERYTHING)) {
            return;
        }
        WetlandWhimsy.LOGGER.debug("\nnewFogColor: " + String.valueOf(this.newFogColor) + "\nnewSkyColor: " + String.valueOf(this.newSkyColor) + "\nnewWaterColor: " + String.valueOf(this.newWaterColor) + "\nnewWaterFogColor: " + String.valueOf(this.newWaterFogColor) + "\nnewGrassColorOverride: " + String.valueOf(this.newGrassColorOverride) + "\nnewFoliageColorOverride: " + String.valueOf(this.newFoliageColorOverride) + "\nnewGrassModifier: " + String.valueOf(this.newGrassModifier));
        BiomeSpecialEffectsBuilder environment = builder.getSpecialEffects();
        environment.fogColor(this.newFogColor.orElse(environment.getFogColor()).intValue()).skyColor(this.newSkyColor.orElse(environment.getSkyColor()).intValue()).waterColor(this.newWaterColor.orElse(environment.waterColor()).intValue()).waterFogColor(this.newWaterFogColor.orElse(environment.getWaterFogColor()).intValue()).grassColorModifier(this.newGrassModifier.orElse(environment.getGrassColorModifier()));
        this.newGrassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)environment).grassColorOverride(arg_0));
        this.newFoliageColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffectsBuilder)environment).foliageColorOverride(arg_0));
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

