/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.aria_mushroom;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.blocks.AriaMushroomBlock;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTreeDecorators;

public class AriaMushroomTreeDecorator
extends TreeDecorator {
    public static final MapCodec<AriaMushroomTreeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(AriaMushroomTreeDecorator::new, instance -> Float.valueOf(instance.probability));
    private final float probability;

    public AriaMushroomTreeDecorator(float probability) {
        this.probability = probability;
    }

    public void place(@Nonnull TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (random.nextFloat() >= this.probability) {
            return;
        }
        ObjectArrayList list = context.logs();
        int i = ((BlockPos)list.get(0)).getY();
        list.stream().filter(pos -> pos.getY() - i <= 2).forEach(pos -> {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                Direction newdir;
                BlockPos newpos;
                if (random.nextFloat() > 0.5f || !context.isAir(newpos = pos.offset((newdir = dir.getOpposite()).getStepX(), 0, newdir.getStepZ()))) continue;
                context.setBlock(newpos, (BlockState)((AriaMushroomBlock)((Object)((Object)WetlandWhimsyBlocks.ARIA_MUSHROOM.get()))).defaultBlockState().setValue(AriaMushroomBlock.FACING, (Comparable)dir));
            }
        });
    }

    protected TreeDecoratorType<?> type() {
        return WetlandWhimsyTreeDecorators.ARIA_MUSHROOMS.get();
    }
}

