/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.worldgen.aria_mushroom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyFoliagePlacers;

@ParametersAreNonnullByDefault
public class AriaMushroomFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<AriaMushroomFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(parts -> AriaMushroomFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)parts).apply((Applicative)parts, AriaMushroomFoliagePlacer::new));

    public AriaMushroomFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return random.nextInt(4, 6);
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        int leafHeight = foliageHeight - random.nextInt(1, 2);
        for (int i = 0; i < foliageHeight; ++i) {
            this.placeLeavesRow(level, blockSetter, random, config, pos, offset, i - leafHeight, false);
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return (float)Mth.square((int)localX) + this.funniTreeMath(localY) + (float)Mth.square((int)localZ) > (float)range;
    }

    private float funniTreeMath(int y) {
        float val = Mth.sin((float)(y * Mth.abs((int)y))) * 5.0f;
        return val > 2.0f ? 999.0f : val;
    }

    protected FoliagePlacerType<?> type() {
        return WetlandWhimsyFoliagePlacers.ARIA_MUSHROOM_FOLIAGE_PLACER.get();
    }
}

