/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import uwu.juni.wetland_whimsy.WetlandWhimsyCompat;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class WetlandWhimsyRecipes
extends RecipeProvider {
    RecipeOutput recipeOutput;

    protected WetlandWhimsyRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.recipeOutput = recipeOutput;
        WetlandWhimsyRecipes.planksFromLog((RecipeOutput)recipeOutput, WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS, WetlandWhimsyTags.Items.BALD_CYPRESS_LOGS, (int)4);
        this.twoByTwo((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_LOG, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_WOOD, 3);
        this.twoByTwo((ItemLike)WetlandWhimsyBlocks.STRIPPED_BALD_CYPRESS_LOG, (ItemLike)WetlandWhimsyBlocks.STRIPPED_BALD_CYPRESS_WOOD, 3);
        this.stairsAndSlab((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_STAIRS, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_SLAB);
        this.doorAndTrapdoor((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_DOOR, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_TRAPDOOR);
        this.buttonAndPressurePlate((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_BUTTON, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_PRESSURE_PLATE);
        this.fenceAndFenceGate((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_FENCE, (ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_FENCE_GATE);
        WetlandWhimsyRecipes.hangingSign((RecipeOutput)recipeOutput, WetlandWhimsyBlocks.BALD_CYPRESS_HANGING_SIGN, WetlandWhimsyBlocks.STRIPPED_BALD_CYPRESS_LOG);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, WetlandWhimsyBlocks.BALD_CYPRESS_SIGN, (int)3).group("wooden_sign").define(Character.valueOf('P'), WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("PPP").pattern("PPP").pattern(" / ").unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS)).save(recipeOutput);
        this.twoByTwo((ItemLike)WetlandWhimsyBlocks.LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE, 4);
        this.twoByTwo((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICKS, 4);
        this.stairsAndSlab((ItemLike)WetlandWhimsyBlocks.LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_STAIRS, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_SLAB);
        this.stairsAndSlab((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE_STAIRS, (ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE_SLAB);
        this.stairsAndSlab((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICKS, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICK_STAIRS, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICK_SLAB);
        this.wall((ItemLike)WetlandWhimsyBlocks.LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_WALL);
        this.wall((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE, (ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE_WALL);
        this.wall((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICKS, (ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICK_WALL);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_PILLAR.get()), (int)2).group("lemonstone").define(Character.valueOf('L'), WetlandWhimsyBlocks.POLISHED_LEMONSTONE).pattern("L").pattern("L").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE.get())), WetlandWhimsyRecipes.has((ItemLike)((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE.get()))).save(recipeOutput);
        this.stonecutterList((ItemLike)WetlandWhimsyBlocks.LEMONSTONE, List.of(WetlandWhimsyBlocks.LEMONSTONE_STAIRS, WetlandWhimsyBlocks.LEMONSTONE_SLAB, WetlandWhimsyBlocks.LEMONSTONE_WALL, WetlandWhimsyBlocks.POLISHED_LEMONSTONE, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_STAIRS, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_SLAB, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_WALL, WetlandWhimsyBlocks.LEMONSTONE_BRICKS, WetlandWhimsyBlocks.LEMONSTONE_BRICK_STAIRS, WetlandWhimsyBlocks.LEMONSTONE_BRICK_SLAB, WetlandWhimsyBlocks.LEMONSTONE_BRICK_WALL, WetlandWhimsyBlocks.LEMONSTONE_PILLAR));
        this.stonecutterList((ItemLike)WetlandWhimsyBlocks.POLISHED_LEMONSTONE, (List<ItemLike>)List.of(WetlandWhimsyBlocks.POLISHED_LEMONSTONE_STAIRS, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_SLAB, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_WALL, WetlandWhimsyBlocks.LEMONSTONE_BRICKS, WetlandWhimsyBlocks.LEMONSTONE_BRICK_STAIRS, WetlandWhimsyBlocks.LEMONSTONE_BRICK_SLAB, WetlandWhimsyBlocks.LEMONSTONE_BRICK_WALL, WetlandWhimsyBlocks.LEMONSTONE_PILLAR));
        this.stonecutterList((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRICKS, (List<ItemLike>)List.of(WetlandWhimsyBlocks.LEMONSTONE_BRICK_STAIRS, WetlandWhimsyBlocks.LEMONSTONE_BRICK_SLAB, WetlandWhimsyBlocks.LEMONSTONE_BRICK_WALL, WetlandWhimsyBlocks.LEMONSTONE_PILLAR));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, WetlandWhimsyItems.PENNYWORT_SALAD).requires(WetlandWhimsyBlocks.PENNYWORT, 2).requires((ItemLike)Items.BEETROOT, 2).requires((ItemLike)Items.BOWL).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.PENNYWORT), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.PENNYWORT)).save(recipeOutput);
        this.cookMeat((ItemLike)WetlandWhimsyItems.CRAWFISH, (ItemLike)WetlandWhimsyItems.COOKED_CRAWFISH, recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, WetlandWhimsyItems.POPCORN_CRAWFISH, (int)3).requires(WetlandWhimsyItems.COOKED_CRAWFISH).requires((ItemLike)Items.MILK_BUCKET).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.EGG).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.COOKED_CRAWFISH), WetlandWhimsyRecipes.has(WetlandWhimsyItems.COOKED_CRAWFISH)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, WetlandWhimsyItems.GUMBO).requires(WetlandWhimsyItems.COOKED_CRAWFISH).requires((ItemLike)Items.KELP).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.BOWL).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.COOKED_CRAWFISH), WetlandWhimsyRecipes.has(WetlandWhimsyItems.COOKED_CRAWFISH)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE.get()), (int)2).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('T'), WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE).define(Character.valueOf('L'), WetlandWhimsyBlocks.LEMONSTONE).pattern("DTD").pattern("DLD").pattern("DDD").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)((ItemLike)WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE.get())), WetlandWhimsyRecipes.has((ItemLike)((ItemLike)WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRAZIER.get()), (int)1).define(Character.valueOf('C'), ItemTags.COALS).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('L'), WetlandWhimsyBlocks.POLISHED_LEMONSTONE).pattern("LCL").pattern("LRL").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRAZIER.get())), WetlandWhimsyRecipes.has((ItemLike)((ItemLike)WetlandWhimsyBlocks.LEMONSTONE_BRAZIER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WetlandWhimsyBlocks.SOUL_BRAZIER.get()), (int)1).define(Character.valueOf('C'), ItemTags.SOUL_FIRE_BASE_BLOCKS).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('L'), WetlandWhimsyBlocks.POLISHED_LEMONSTONE).pattern("LCL").pattern("LRL").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)((ItemLike)WetlandWhimsyBlocks.SOUL_BRAZIER.get())), WetlandWhimsyRecipes.has((ItemLike)((ItemLike)WetlandWhimsyBlocks.SOUL_BRAZIER.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WetlandWhimsyBlocks.ARIA_SPORES.get()), (int)3).requires(WetlandWhimsyBlocks.ARIA_MUSHROOM).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.ARIA_MUSHROOM), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.ARIA_MUSHROOM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, WetlandWhimsyItems.DAGGER, (int)1).define(Character.valueOf('D'), WetlandWhimsyItems.RUSTED_ARTIFACT).define(Character.valueOf('B'), WetlandWhimsyItems.FILTHY_BONE).pattern(" D").pattern("B ").unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.RUSTED_ARTIFACT), WetlandWhimsyRecipes.has(WetlandWhimsyItems.RUSTED_ARTIFACT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, WetlandWhimsyItems.BALD_CYPRESS_BOAT, (int)1).define(Character.valueOf('P'), WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS).pattern("P P").pattern("PPP").unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, WetlandWhimsyItems.BALD_CYPRESS_CHEST_BOAT).requires(WetlandWhimsyItems.BALD_CYPRESS_BOAT).requires((ItemLike)Items.CHEST).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.BALD_CYPRESS_PLANKS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, WetlandWhimsyItems.SLUDGE_CHARGE).requires(WetlandWhimsyItems.FILTHY_BONE, 2).requires(WetlandWhimsyBlocks.FELLCAP_MUSHROOM).requires((ItemLike)Items.MUD).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.FILTHY_BONE), WetlandWhimsyRecipes.has(WetlandWhimsyItems.FILTHY_BONE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, WetlandWhimsyItems.BASIC_INCENSE, (int)2).requires(WetlandWhimsyItems.BASIC_INCENSE).requires(WetlandWhimsyItems.FILTHY_BONE, 3).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.BASIC_INCENSE), WetlandWhimsyRecipes.has(WetlandWhimsyItems.BASIC_INCENSE)).save(recipeOutput);
        this.incense((ItemLike)WetlandWhimsyItems.BOILING_INCENSE, (ItemLike)Items.BLAZE_ROD, (ItemLike)Items.MAGMA_CREAM);
        this.incense((ItemLike)WetlandWhimsyItems.BRINE_INCENSE, (ItemLike)Items.BREEZE_ROD, (ItemLike)Items.PRISMARINE_CRYSTALS);
        this.incense((ItemLike)WetlandWhimsyItems.ROT_INCENSE, (ItemLike)WetlandWhimsyItems.FILTHY_BONE, (ItemLike)Items.ROTTEN_FLESH);
        this.incense((ItemLike)WetlandWhimsyItems.WEBBED_INCENSE, (ItemLike)Items.STRING, (ItemLike)Items.FERMENTED_SPIDER_EYE);
        if (WetlandWhimsyCompat.FARMERS_DELIGHT) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WetlandWhimsyBlocks.BALD_CYPRESS_CABINET.get()), (int)1).define(Character.valueOf('T'), WetlandWhimsyBlocks.BALD_CYPRESS_TRAPDOOR).define(Character.valueOf('S'), WetlandWhimsyBlocks.BALD_CYPRESS_SLAB).pattern("SSS").pattern("T T").pattern("SSS").unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyBlocks.BALD_CYPRESS_TRAPDOOR), WetlandWhimsyRecipes.has(WetlandWhimsyBlocks.BALD_CYPRESS_TRAPDOOR)).save(recipeOutput);
        }
    }

    private void twoByTwo(ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)count).define(Character.valueOf('I'), input).pattern("II").pattern("II").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
    }

    private void stairsAndSlab(ItemLike input, ItemLike stairs, ItemLike slab) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).define(Character.valueOf('S'), input).pattern("S  ").pattern("SS ").pattern("SSS").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).define(Character.valueOf('S'), input).pattern("SSS").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
    }

    private void wall(ItemLike input, ItemLike wall) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)6).define(Character.valueOf('P'), input).pattern("PPP").pattern("PPP").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
    }

    private void doorAndTrapdoor(ItemLike input, ItemLike door, ItemLike trapdoor) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)door, (int)3).define(Character.valueOf('P'), input).pattern("PP").pattern("PP").pattern("PP").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)trapdoor, (int)3).define(Character.valueOf('P'), input).pattern("PPP").pattern("PPP").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
    }

    private void buttonAndPressurePlate(ItemLike input, ItemLike button, ItemLike pressurePlate) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)button, (int)1).define(Character.valueOf('P'), input).pattern("P").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
        WetlandWhimsyRecipes.pressurePlate((RecipeOutput)this.recipeOutput, (ItemLike)pressurePlate, (ItemLike)input);
    }

    private void fenceAndFenceGate(ItemLike input, ItemLike fence, ItemLike gate) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fence, (int)3).define(Character.valueOf('P'), input).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("P/P").pattern("P/P").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gate, (int)1).define(Character.valueOf('P'), input).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).pattern("/P/").pattern("/P/").unlockedBy(WetlandWhimsyRecipes.getHasName((ItemLike)input), WetlandWhimsyRecipes.has((ItemLike)input)).save(this.recipeOutput);
    }

    private void incense(ItemLike incense, ItemLike ingredient1, ItemLike ingredient2) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)incense).requires(WetlandWhimsyItems.BASIC_INCENSE).requires((ItemLike)Items.LAPIS_LAZULI, 4).requires(ingredient1, 2).requires(ingredient2, 2).unlockedBy(WetlandWhimsyRecipes.getHasName(WetlandWhimsyItems.BASIC_INCENSE), WetlandWhimsyRecipes.has(WetlandWhimsyItems.BASIC_INCENSE)).save(this.recipeOutput);
    }

    private void cookMeat(ItemLike raw, ItemLike cooked, RecipeOutput output) {
        Ingredient rawIngredient = Ingredient.of((ItemLike[])new ItemLike[]{raw.asItem()});
        RecipeCategory category = RecipeCategory.FOOD;
        float exp = 0.35f;
        String hasName = WetlandWhimsyRecipes.getHasName((ItemLike)raw.asItem());
        Criterion has = WetlandWhimsyRecipes.has((ItemLike)raw.asItem());
        String cookedName = WetlandWhimsyRecipes.getItemName((ItemLike)cooked.asItem());
        SimpleCookingRecipeBuilder.smelting((Ingredient)rawIngredient, (RecipeCategory)category, (ItemLike)cooked.asItem(), (float)0.35f, (int)200).unlockedBy(hasName, has).save(output, cookedName + "_furnace");
        SimpleCookingRecipeBuilder.smoking((Ingredient)rawIngredient, (RecipeCategory)category, (ItemLike)cooked.asItem(), (float)0.35f, (int)100).unlockedBy(hasName, has).save(output, cookedName + "_smoker");
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)rawIngredient, (RecipeCategory)category, (ItemLike)cooked.asItem(), (float)0.35f, (int)600).unlockedBy(hasName, has).save(output, cookedName + "_campfire");
    }

    private void stonecutterList(ItemLike input, List<ItemLike> outputs) {
        for (ItemLike output : outputs) {
            WetlandWhimsyRecipes.stonecutterResultFromBase((RecipeOutput)this.recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (ItemLike)input, (int)(output.toString().contains("slab") ? 2 : 1));
        }
    }
}

