/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities.goals;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.phys.Vec3;
import uwu.juni.wetland_whimsy.content.entities.CraneEntity;

public class CraneFlyGoal
extends JumpGoal {
    private static final Integer[] ALLOWED_ANGLES = new Integer[]{20, 25, 30, 35, 40, 45};
    protected final CraneEntity crane;
    protected Vec3 target;

    public CraneFlyGoal(CraneEntity crane) {
        this.crane = crane;
    }

    public boolean canUse() {
        int discardChance = 80;
        if (this.crane.getRandom().nextInt(0, 80) < 79 || !this.crane.onGround() && !this.crane.isInWater() || Swim.shouldSwim((Mob)this.crane)) {
            return false;
        }
        this.target = this.getTarget();
        return true;
    }

    protected Vec3 getTarget() {
        RandomSource random = this.crane.getRandom();
        Supplier<Integer> a = () -> {
            int i = random.nextInt(7, 14);
            return random.nextBoolean() ? i : i * -1;
        };
        return this.crane.position().add((double)a.get().intValue(), 0.0, (double)a.get().intValue());
    }

    public void start() {
        Optional<Vec3> v3 = CraneFlyGoal.calculateOptimalJumpVector(this.crane, this.crane.getRandom(), this.target);
        if (v3.isEmpty()) {
            return;
        }
        this.crane.setDeltaMovement(v3.get());
        this.crane.lookAt(EntityAnchorArgument.Anchor.EYES, this.target);
        this.crane.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 30, 1, true, false));
    }

    private static Optional<Vec3> calculateOptimalJumpVector(CraneEntity crane, RandomSource random, Vec3 target) {
        Iterator iterator = Util.shuffledCopy((Object[])ALLOWED_ANGLES, (RandomSource)random).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional opt = LongJumpUtil.calculateJumpVectorForAngle((Mob)crane, (Vec3)target, (float)1.4f, (int)i, (boolean)false);
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }
}

