/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class CrawfishEntity
extends WaterAnimal {
    public final AnimationState idleAnimationState = new AnimationState();

    public CrawfishEntity(EntityType<? extends CrawfishEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        ImmutableList goals = ImmutableList.of((Object)new PanicGoal((PathfinderMob)this, 1.2), (Object)new TryFindWaterGoal((PathfinderMob)this), (Object)new RandomStrollGoal((PathfinderMob)this, 1.0), (Object)new RandomLookAroundGoal((Mob)this));
        int priority = 0;
        for (Goal goal : goals) {
            this.goalSelector.addGoal(priority, goal);
            ++priority;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.65).add(Attributes.MAX_HEALTH, 4.0);
    }

    void setupAnimationStates() {
        this.idleAnimationState.startIfStopped(this.tickCount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    protected void handleAirSupply(int airSupply) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)WetlandWhimsySounds.CRAWFISH_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)WetlandWhimsySounds.CRAWFISH_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)WetlandWhimsySounds.CRAWFISH_DEATH.get();
    }

    public static boolean checkCrawfishSpawnRules(EntityType<CrawfishEntity> crawfish, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockState below = level.getBlockState(pos.below());
        boolean onMud = below.is(WetlandWhimsyTags.Blocks.SPAWNS_CRAWFISH_SURFACE);
        boolean inWater = below.isSolidRender((BlockGetter)level, pos) && level.getFluidState(pos).is(FluidTags.WATER);
        return onMud || inWater;
    }
}

