/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class PennywortBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final int MAX_PENNYWORTS = 4;
    public static final IntegerProperty PENNYWORT_COUNT = BlockStateProperties.FLOWER_AMOUNT;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);

    public PennywortBlock(Holder<MobEffect> effect, float time, BlockBehaviour.Properties properties) {
        super(effect, time, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)PENNYWORT_COUNT, (Comparable)Integer.valueOf(1)));
    }

    protected VoxelShape getShape(BlockState a, BlockGetter b, BlockPos c, CollisionContext d) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PENNYWORT_COUNT, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            Integer count = (Integer)state.getValue((Property)PENNYWORT_COUNT);
            return (BlockState)state.setValue((Property)PENNYWORT_COUNT, (Comparable)Integer.valueOf(count != 4 ? count + 1 : 4));
        }
        BlockState s = super.getStateForPlacement(context);
        return s == null ? s : (BlockState)s.setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)PENNYWORT_COUNT) < 4 ? true : super.canBeReplaced(state, useContext);
    }

    public boolean isValidBonemealTarget(LevelReader a, BlockPos b, BlockState c) {
        return true;
    }

    public boolean isBonemealSuccess(Level a, RandomSource b, BlockPos c, BlockState d) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Integer count = (Integer)state.getValue((Property)PENNYWORT_COUNT);
        if (count == 4) {
            PennywortBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)PENNYWORT_COUNT, (Comparable)Integer.valueOf(count + 1)), 2);
        }
    }
}

