/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;

@ParametersAreNonnullByDefault
public class BouncyMushroomBlock
extends HalfTransparentBlock {
    final float bounceMult;

    public BouncyMushroomBlock(float bounceMult, BlockBehaviour.Properties properties) {
        super(properties);
        this.bounceMult = bounceMult;
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.y >= 0.0) {
            return;
        }
        entity.playSound((SoundEvent)WetlandWhimsySounds.MUSHROOM_BOUNCE.get(), (float)vec3.y * -1.0f, (float)entity.getRandom().nextInt(9, 11) / 10.0f);
        double bounceAmount = entity instanceof LivingEntity ? 1.0 : 0.8;
        entity.setDeltaMovement(vec3.x, -vec3.y * bounceAmount * (double)this.bounceMult, vec3.z);
    }
}

