/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import uwu.juni.wetland_whimsy.WetlandWhimsyConfig;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyAdvancementTriggers;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientPotBlockEntity;

@ParametersAreNonnullByDefault
public class AncientPotBlock
extends BaseEntityBlock {
    public static final MapCodec<AncientPotBlock> CODEC = AncientPotBlock.simpleCodec(AncientPotBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public AncientPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AncientPotBlockEntity(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.is(WetlandWhimsyItems.ANCIENT_COIN)) {
            return ItemInteractionResult.FAIL;
        }
        if (!player.isCreative()) {
            stack.consumeAndReturn(1, (LivingEntity)player);
        }
        AncientPotBlockEntity entity = (AncientPotBlockEntity)((Object)level.getBlockEntity(pos, WetlandWhimsyBlockEntities.ANCIENT_POT.get()).get());
        entity.increaseLootQuality();
        entity.setChanged();
        level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        level.updateNeighborsAt(pos, (Block)this);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
        }
        level.playSound(null, pos, (SoundEvent)WetlandWhimsySounds.ANCIENT_POT_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.dropLoot(level, pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AncientPotBlockEntity) {
                AncientPotBlockEntity ap = (AncientPotBlockEntity)blockEntity;
                WetlandWhimsyAdvancementTriggers.ANCIENT_POT_TRIGGER.get().trigger(sp, ap.lootQuality());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        BlockPos pos = result.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, pos) && projectile.mayBreak(level)) {
            this.dropLoot(level, pos);
            level.destroyBlock(pos, true, (Entity)projectile);
        }
    }

    private void dropLoot(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AncientPotBlockEntity blockEntity = (AncientPotBlockEntity)((Object)serverLevel.getBlockEntity(pos, WetlandWhimsyBlockEntities.ANCIENT_POT.get()).get());
            blockEntity.dropLoot(serverLevel, pos);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)WetlandWhimsyParticleTypes.ANCIENT_SOULS.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, Math.min((Integer)WetlandWhimsyConfig.ANCIENT_POT_MAX_PARTICLES.get(), blockEntity.lootQuality() - 1), 0.2, 0.2, 0.2, 0.0);
        }
    }
}

