/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientBrazierBlockEntity;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class AncientBrazierBlock
extends BaseEntityBlock {
    public static final MapCodec<AncientBrazierBlock> CODEC = AncientBrazierBlock.simpleCodec(AncientBrazierBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    public static final EnumProperty<Flame> FLAME = EnumProperty.create((String)"flame", Flame.class, (Enum[])new Flame[]{Flame.LIT, Flame.SMOLDERING, Flame.UNLIT});

    public AncientBrazierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FLAME, (Comparable)((Object)Flame.UNLIT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FLAME});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AncientBrazierBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FLAME, (Comparable)((Object)Flame.UNLIT));
    }

    protected VoxelShape getShape(BlockState a, BlockGetter b, BlockPos c, CollisionContext d) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemInteractionResult fail = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        ItemInteractionResult success = ItemInteractionResult.SUCCESS;
        if (stack.is(WetlandWhimsyTags.Items.INCENSE) && (blockEntity = level.getBlockEntity(pos)) instanceof AncientBrazierBlockEntity) {
            AncientBrazierBlockEntity brazier = (AncientBrazierBlockEntity)blockEntity;
            boolean bool = brazier.trySetIncense((ItemLike)stack.getItem());
            if (!bool) {
                return fail;
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                this.createParticles(sLevel, pos);
            }
            level.setBlock(pos, (BlockState)state.setValue(FLAME, (Comparable)((Object)Flame.UNLIT)), 2);
            return success;
        }
        if (!this.canBeLit(state, pos, level)) {
            return fail;
        }
        if (stack.is(ItemTags.CREEPER_IGNITERS)) {
            SoundEvent sound = stack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)state.setValue(FLAME, (Comparable)((Object)Flame.LIT)), 11);
            if (!level.isClientSide && !player.isCreative()) {
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
                } else {
                    stack.shrink(1);
                }
            }
            return success;
        }
        return fail;
    }

    private void createParticles(ServerLevel level, BlockPos pos) {
        RandomSource random = level.getRandom();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AncientBrazierBlockEntity) {
            AncientBrazierBlockEntity ab = (AncientBrazierBlockEntity)be;
            Vector3f color = ab.getIncense(level).get().color();
            for (int i = 0; i < random.nextInt(8, 12); ++i) {
                level.sendParticles((ParticleOptions)new DustParticleOptions(color, 1.0f), (double)((float)pos.getX() + (float)random.nextInt(2, 8) / 10.0f), (double)pos.getY() + 0.5, (double)((float)pos.getZ() + (float)random.nextInt(2, 8) / 10.0f), 1, 0.0, 0.0, 0.0, 0.5);
            }
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity && ((Flame)((Object)state.getValue(FLAME))).isLit()) {
            entity.hurt(level.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (!((Flame)((Object)state.getValue(FLAME))).equals((Object)Flame.LIT)) {
            return;
        }
        if (random.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.getBlockPos();
        if (!level.isClientSide && projectile.isOnFire() && projectile.mayInteract(level, blockpos) && this.canBeLit(state, blockpos, level)) {
            level.setBlock(blockpos, (BlockState)state.setValue(FLAME, (Comparable)((Object)Flame.LIT)), 11);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return AncientBrazierBlock.createTickerHelper(blockEntityType, WetlandWhimsyBlockEntities.ANCIENT_BRAZIER.get(), (BlockEntityTicker)(level.isClientSide ? AncientBrazierBlockEntity::clientTick : AncientBrazierBlockEntity::serverTick));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType path) {
        return !((Flame)((Object)state.getValue(FLAME))).isLit();
    }

    private boolean canBeLit(BlockState state, BlockPos pos, Level level) {
        AncientBrazierBlockEntity ab;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        boolean hasIncense = blockEntity instanceof AncientBrazierBlockEntity && (ab = (AncientBrazierBlockEntity)blockEntity).hasIncense();
        return !((Flame)((Object)state.getValue(FLAME))).isLit() || hasIncense;
    }

    public static enum Flame implements StringRepresentable
    {
        LIT,
        SMOLDERING,
        UNLIT;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "lit";
                case 1 -> "smoldering";
                case 2 -> "unlit";
            };
        }

        private boolean isLit() {
            return this != UNLIT;
        }
    }
}

