/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;

public class WetlandWhimsyLoot {
    private static final ConstantValue ROLLS = ConstantValue.exactly((float)1.0f);

    public static LootTable.Builder createCommonMudLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SLIME_BALL)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.BEETROOT)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.BALD_CYPRESS_LOG)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.FELLCAP_MUSHROOM)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.ARIA_SPORES)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.GROWTH_POTTERY_SHERD)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.MUSIC_DISC_NUKE_THE_SWAMPS)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.RAW_IRON)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.RAW_COPPER)).add(WetlandWhimsyLoot.lootEntry(3, (ItemLike)Items.IRON_NUGGET)).add(WetlandWhimsyLoot.lootEntry(3, (ItemLike)Items.AMETHYST_SHARD)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.LEMONSTONE)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.LEMONSTONE_BRICKS)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.POLISHED_LEMONSTONE)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.LEMONSTONE_PILLAR)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.LEMONSTONE_STAIRS)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.LEMONSTONE_BRICK_STAIRS)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyBlocks.POLISHED_LEMONSTONE_STAIRS)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.CHAIN)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.STICK)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.BOWL)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SUSPICIOUS_STEW).apply(WetlandWhimsyLoot.stew())).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.ARROW)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.TIPPED_ARROW)).apply(WetlandWhimsyLoot.potion("poison")));
    }

    public static LootTable.Builder createUncommonMudLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.GROWTH_POTTERY_SHERD)).add(WetlandWhimsyLoot.lootEntry(3, WetlandWhimsyItems.SEALED_POTTERY_SHERD)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.RUSTED_ARTIFACT)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.ANCIENT_COIN)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.IRON_INGOT)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.COPPER_INGOT)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.DIAMOND)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.EMERALD)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.LAPIS_LAZULI)).add(WetlandWhimsyLoot.lootEntry(3, (ItemLike)Items.AMETHYST_SHARD)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLDEN_CARROT)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SUSPICIOUS_STEW).apply(WetlandWhimsyLoot.stew())).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.IRON_SWORD)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.BOW)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.ARROW)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.TIPPED_ARROW)).apply(WetlandWhimsyLoot.potion("poison")));
    }

    public static LootTable.Builder createDecoratedPotLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.DOTS_ARMOR_TRIM_SMITHING_TEMPLATE)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.MUSIC_DISC_NUKE_THE_SWAMPS)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyBlocks.PENNYWORT, 3.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyBlocks.CORDGRASS, 3.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.DEAD_BUSH, 3.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.MUD, 2.0, 8.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SLIME_BALL, 2.0, 8.0)).add(WetlandWhimsyLoot.lootEntry(3, (ItemLike)Items.BEETROOT, 2.0, 12.0)).add(WetlandWhimsyLoot.lootEntry(3, (ItemLike)Items.CARROT, 2.0, 12.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.RAW_IRON, 3.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.RAW_COPPER, 3.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.IRON_INGOT, 1.0, 6.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.COPPER_INGOT, 1.0, 6.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.EMERALD, 1.0, 3.0)).add(WetlandWhimsyLoot.lootEntry(3, WetlandWhimsyItems.CRAWFISH, 1.0, 3.0)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.PENNYWORT_SALAD)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.GUMBO)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SUSPICIOUS_STEW).apply(WetlandWhimsyLoot.stew())).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.ARROW, 4.0, 18.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.TIPPED_ARROW, 3.0, 12.0)).apply(WetlandWhimsyLoot.potion("poison")));
    }

    public static LootTable.Builder createAncientBrazierLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(12, WetlandWhimsyItems.ANCIENT_COIN, 1.0, 4.0)).add(WetlandWhimsyLoot.lootEntry(6, WetlandWhimsyItems.BASIC_INCENSE, 1.0, 2.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.IRON_INGOT, 8.0, 12.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.COPPER_INGOT, 8.0, 12.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.DIAMOND, 3.0, 6.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.EMERALD, 7.0, 12.0)).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.LAPIS_LAZULI, 4.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLDEN_CARROT, 2.0, 5.0)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.GUMBO)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SUSPICIOUS_STEW).apply(WetlandWhimsyLoot.stew())).add(WetlandWhimsyLoot.lootEntry(2, (ItemLike)Items.TIPPED_ARROW, 6.0, 22.0)).apply(WetlandWhimsyLoot.potion("poison")));
    }

    public static LootTable.Builder createBoilingLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.BLAZE_ROD, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.FIRE_CHARGE, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLD_BLOCK, 1.0, 2.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLD_INGOT, 6.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLDEN_APPLE, 1.0, 3.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.ENCHANTED_GOLDEN_APPLE)).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.ANCIENT_COIN, 1.0, 2.0)));
    }

    public static LootTable.Builder createBrineLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.BREEZE_ROD, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.WIND_CHARGE, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SEA_LANTERN, 2.0, 4.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.PRISMARINE_SHARD, 6.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.PRISMARINE_CRYSTALS, 4.0, 13.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SPONGE)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.POTION).apply(WetlandWhimsyLoot.potion("water_breathing"))).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.ANCIENT_COIN, 1.0, 2.0)));
    }

    public static LootTable.Builder createRotLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.FILTHY_BONE, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, WetlandWhimsyItems.SLUDGE_CHARGE, 6.0, 10.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.CHAIN, 12.0, 14.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.IRON_BLOCK, 1.0, 2.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.IRON_INGOT, 6.0, 16.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.GOLDEN_CARROT, 2.0, 3.0)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SPLASH_POTION).apply(WetlandWhimsyLoot.potion("poison"))).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.ANCIENT_COIN, 1.0, 2.0)));
    }

    public static LootTable.Builder createWebbedLoot() {
        return LootTable.lootTable().withPool(WetlandWhimsyLoot.simplePool().add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.COBWEB, 9.0, 18.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.STRING, 16.0, 22.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.ENDER_PEARL, 6.0, 8.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.EMERALD_BLOCK, 1.0, 2.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.COPPER_BLOCK, 1.0, 2.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.DIAMOND_BLOCK)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.DIAMOND, 3.0, 5.0)).add(WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.CROSSBOW)).add((LootPoolEntryContainer.Builder)WetlandWhimsyLoot.lootEntry(1, (ItemLike)Items.SUSPICIOUS_STEW).apply(WetlandWhimsyLoot.stew())).add(WetlandWhimsyLoot.lootEntry(2, WetlandWhimsyItems.ANCIENT_COIN, 1.0, 2.0)));
    }

    public static LootItemConditionalFunction.Builder<?> lootCount(float a, float b) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)a, (float)b));
    }

    private static LootItemConditionalFunction.Builder<?> stew() {
        return SetStewEffectFunction.stewEffect().withEffect(MobEffects.POISON, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.SATURATION, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.HUNGER, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.LUCK, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.UNLUCK, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.BLINDNESS, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)).withEffect(MobEffects.DARKNESS, (NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f));
    }

    private static LootItemConditionalFunction.Builder<?> potion(String effect) {
        Optional potion = BuiltInRegistries.POTION.getHolder(ResourceLocation.withDefaultNamespace((String)effect));
        return SetPotionFunction.setPotion((Holder)((Holder)potion.get()));
    }

    public static LootPoolSingletonContainer.Builder<?> lootEntry(int weight, ItemLike item) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    public static LootPoolSingletonContainer.Builder<?> lootEntry(int weight, ItemLike item, double min, double max) {
        return WetlandWhimsyLoot.lootEntry(weight, item).apply(WetlandWhimsyLoot.lootCount((float)min, (float)max));
    }

    private static LootPool.Builder simplePool() {
        return LootPool.lootPool().setRolls((NumberProvider)ROLLS);
    }
}

