/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import uwu.juni.wetland_whimsy.WetlandWhimsyCompat;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.blocks.AncientBrazierBlock;
import uwu.juni.wetland_whimsy.content.blocks.AncientPotBlock;
import uwu.juni.wetland_whimsy.content.blocks.AriaMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.BouncyMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.BrazierBlock;
import uwu.juni.wetland_whimsy.content.blocks.CordgrassBlock;
import uwu.juni.wetland_whimsy.content.blocks.FellcapMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.PennywortBlock;
import uwu.juni.wetland_whimsy.content.blocks.StrippableLogBlock;
import uwu.juni.wetland_whimsy.content.blocks.SussyMudBlock;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyWoodTypes;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTreeGrowers;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@ParametersAreNonnullByDefault
public class WetlandWhimsyBlocks {
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"wetland_whimsy");
    public static final DeferredBlock<StrippableLogBlock> BALD_CYPRESS_LOG = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_log", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> STRIPPED_BALD_CYPRESS_LOG = WetlandWhimsyBlocks.registerBlockAndItem("stripped_bald_cypress_log", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> BALD_CYPRESS_WOOD = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_wood", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<StrippableLogBlock> STRIPPED_BALD_CYPRESS_WOOD = WetlandWhimsyBlocks.registerBlockAndItem("stripped_bald_cypress_wood", () -> new StrippableLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<SaplingBlock> BALD_CYPRESS_SAPLING = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_sapling", () -> new SaplingBlock(WetlandWhimsyTreeGrowers.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<LeavesBlock> BALD_CYPRESS_LEAVES = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }
    });
    public static final DeferredBlock<Block> BALD_CYPRESS_PLANKS = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<StairBlock> BALD_CYPRESS_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_stairs", () -> new StairBlock(((Block)BALD_CYPRESS_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<SlabBlock> BALD_CYPRESS_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceBlock> BALD_CYPRESS_FENCE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceGateBlock> BALD_CYPRESS_FENCE_GATE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_fence_gate", () -> new FenceGateBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<DoorBlock> BALD_CYPRESS_DOOR = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_door", () -> new DoorBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    public static final DeferredBlock<TrapDoorBlock> BALD_CYPRESS_TRAPDOOR = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_trapdoor", () -> new TrapDoorBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final DeferredBlock<ButtonBlock> BALD_CYPRESS_BUTTON = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_button", () -> new ButtonBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final DeferredBlock<PressurePlateBlock> BALD_CYPRESS_PRESSURE_PLATE = WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_pressure_plate", () -> new PressurePlateBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS_BLOCK_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    public static final DeferredBlock<StandingSignBlock> BALD_CYPRESS_SIGN = REGISTER.register("bald_cypress_sign", () -> new StandingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallSignBlock> BALD_CYPRESS_WALL_SIGN = REGISTER.register("bald_cypress_wall_sign", () -> new WallSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(BALD_CYPRESS_SIGN)));
    public static final DeferredBlock<CeilingHangingSignBlock> BALD_CYPRESS_HANGING_SIGN = REGISTER.register("bald_cypress_hanging_sign", () -> new CeilingHangingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallHangingSignBlock> BALD_CYPRESS_WALL_HANGING_SIGN = REGISTER.register("bald_cypress_wall_hanging_sign", () -> new WallHangingSignBlock(WetlandWhimsyWoodTypes.BALD_CYPRESS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(BALD_CYPRESS_HANGING_SIGN)));
    public static final Optional<DeferredBlock<?>> BALD_CYPRESS_CABINET = WetlandWhimsyCompat.FARMERS_DELIGHT ? Optional.of(WetlandWhimsyBlocks.registerBlockAndItem("bald_cypress_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModBlocks.OAK_CABINET.get()))))) : Optional.empty();
    public static final DeferredBlock<Block> LEMONSTONE = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.CALCITE)));
    public static final DeferredBlock<Block> POLISHED_LEMONSTONE = WetlandWhimsyBlocks.registerBlockAndItem("polished_lemonstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<Block> LEMONSTONE_BRICKS = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<StairBlock> LEMONSTONE_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_stairs", () -> new StairBlock(((Block)LEMONSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_LEMONSTONE_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("polished_lemonstone_stairs", () -> new StairBlock(((Block)POLISHED_LEMONSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<StairBlock> LEMONSTONE_BRICK_STAIRS = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_brick_stairs", () -> new StairBlock(((Block)LEMONSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<SlabBlock> LEMONSTONE_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_LEMONSTONE_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("polished_lemonstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<SlabBlock> LEMONSTONE_BRICK_SLAB = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<WallBlock> LEMONSTONE_WALL = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_LEMONSTONE_WALL = WetlandWhimsyBlocks.registerBlockAndItem("polished_lemonstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<WallBlock> LEMONSTONE_BRICK_WALL = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<RotatedPillarBlock> LEMONSTONE_PILLAR = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get()))));
    public static final DeferredBlock<CordgrassBlock> CORDGRASS = WetlandWhimsyBlocks.registerBlockAndItem("cordgrass", () -> new CordgrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<PennywortBlock> PENNYWORT = WetlandWhimsyBlocks.registerBlockAndItem("pennywort", () -> new PennywortBlock((Holder<MobEffect>)MobEffects.DARKNESS, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<FellcapMushroomBlock> FELLCAP_MUSHROOM = WetlandWhimsyBlocks.registerBlockAndItem("fellcap_mushroom", () -> new FellcapMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel($ -> 2)));
    public static final DeferredBlock<AriaMushroomBlock> ARIA_MUSHROOM = WetlandWhimsyBlocks.registerBlockAndItem("aria_mushroom", () -> new AriaMushroomBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM).noOcclusion().lightLevel($ -> 7)));
    public static final DeferredBlock<HalfTransparentBlock> FELLCAP_MUSHROOM_BLOCK = WetlandWhimsyBlocks.registerBlockAndItem("fellcap_mushroom_block", () -> new BouncyMushroomBlock(0.5f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM_BLOCK).noOcclusion().lightLevel($ -> 3)));
    public static final DeferredBlock<HalfTransparentBlock> ARIA_MUSHROOM_BLOCK = WetlandWhimsyBlocks.registerBlockAndItem("aria_mushroom_block", () -> new BouncyMushroomBlock(0.6666667f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM_BLOCK).noOcclusion().lightLevel($ -> 9)));
    public static final DeferredBlock<SaplingBlock> ARIA_SPORES = WetlandWhimsyBlocks.registerBlockAndItem("aria_spores", () -> new SaplingBlock(WetlandWhimsyTreeGrowers.HUGE_ARIA_MUSHROOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ARIA_MUSHROOM.get()))){
        protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return SHAPE;
        }
    });
    public static final DeferredBlock<SussyMudBlock> SUSSY_MUD = WetlandWhimsyBlocks.registerBlockAndItem("suspicious_mud", () -> new SussyMudBlock(Blocks.MUD, SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND_COMPLETED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<BrazierBlock> LEMONSTONE_BRAZIER = WetlandWhimsyBlocks.registerBlockAndItem("lemonstone_brazier", () -> new BrazierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE.get())).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0)));
    public static final DeferredBlock<BrazierBlock> SOUL_BRAZIER = WetlandWhimsyBlocks.registerBlockAndItem("soul_brazier", () -> new BrazierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE_BRAZIER.get())).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 10 : 0)));
    public static final DeferredBlock<AncientBrazierBlock> ANCIENT_BRAZIER = WetlandWhimsyBlocks.registerBlockAndItem("ancient_brazier", () -> new AncientBrazierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)LEMONSTONE_BRAZIER.get())).sound(SoundType.TRIAL_SPAWNER).lightLevel(state -> switch ((AncientBrazierBlock.Flame)((Object)((Object)((Object)state.getValue(AncientBrazierBlock.FLAME))))) {
        case AncientBrazierBlock.Flame.LIT -> 9;
        case AncientBrazierBlock.Flame.SMOLDERING -> 6;
        default -> 0;
    })));
    public static final DeferredBlock<AncientPotBlock> ANCIENT_POT = WetlandWhimsyBlocks.registerBlockAndItem("ancient_pot", () -> new AncientPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).sound((SoundType)WetlandWhimsySounds.ANCIENT_POT_SOUNDS)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_BALD_CYPRESS_SAPLING = WetlandWhimsyBlocks.flowerPot("potted_bald_cypress_sapling", BALD_CYPRESS_SAPLING);
    public static final DeferredBlock<FlowerPotBlock> POTTED_PENNYWORT = WetlandWhimsyBlocks.flowerPot("potted_pennywort", PENNYWORT);
    public static final DeferredBlock<FlowerPotBlock> POTTED_CORDGRASS = WetlandWhimsyBlocks.flowerPot("potted_cordgrass", CORDGRASS);
    public static final DeferredBlock<FlowerPotBlock> POTTED_FELLCAP_MUSHROOM = WetlandWhimsyBlocks.flowerPot("potted_fellcap_mushroom", FELLCAP_MUSHROOM);
    public static final DeferredBlock<FlowerPotBlock> POTTED_ARIA_MUSHROOM = WetlandWhimsyBlocks.flowerPot("potted_aria_mushroom", ARIA_MUSHROOM);

    public static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Supplier<T> block) {
        DeferredBlock register = REGISTER.register(name, block);
        WetlandWhimsyItems.REGISTER.registerSimpleBlockItem(name, (Supplier)register);
        return register;
    }

    private static DeferredBlock<FlowerPotBlock> flowerPot(String name, DeferredBlock<?> plant) {
        DeferredBlock flowerPot = REGISTER.register(name, () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)plant, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).lightLevel(a -> plant.getId() == ARIA_MUSHROOM.getId() ? 9 : 0)));
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(plant.getId(), (Supplier)flowerPot);
        return flowerPot;
    }
}

