/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.events.WetlandWhimsyRegisters;

public record ScalableReward(int max_drops, List<Loot> rewards) {
    public static final Codec<ScalableReward> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max_drops").forGetter(ScalableReward::max_drops), (App)Loot.CODEC.listOf().fieldOf("rewards").forGetter(ScalableReward::rewards)).apply((Applicative)instance, ScalableReward::new));

    public record Loot(Integer weight, Integer maxStackSize, Either<Item, List<Item>> items, List<ResourceKey<Enchantment>> enchantments) {
        public static final Codec<Loot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(Loot::weight), (App)Codec.INT.optionalFieldOf("max_stack_size", (Object)64).forGetter(Loot::maxStackSize), (App)Codec.either((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)BuiltInRegistries.ITEM.byNameCodec().listOf()).fieldOf("items").forGetter(Loot::items), (App)Codec.list((Codec)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT)).optionalFieldOf("enchantments", List.of()).forGetter(Loot::enchantments)).apply((Applicative)instance, Loot::new));

        public ItemStack getItem(ServerLevel level, int quality) {
            Item item;
            if (this.items().left().isPresent()) {
                item = (Item)this.items().left().get();
            } else {
                List list = (List)this.items().right().get();
                int index = level.getRandom().nextInt(0, list.size());
                item = (Item)list.get(index);
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            this.growStack(level, stack, quality);
            return stack;
        }

        private void growStack(ServerLevel level, @Nonnull ItemStack stack, int quality) {
            RandomSource random = level.getRandom();
            int size = Integer.min(this.maxStackSize, Integer.min(stack.getMaxStackSize(), random.nextInt(1, quality)));
            stack.grow(size - 1);
            if (stack.isDamageableItem()) {
                stack.setDamageValue(random.nextInt(1, stack.getMaxDamage() - 1));
            }
            if (!stack.isEnchantable() || random.nextBoolean()) {
                return;
            }
            HolderLookup.RegistryLookup getter = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            block0: for (ResourceKey<Enchantment> e : this.enchantments) {
                Holder.Reference enchantment;
                if (random.nextBoolean() || !stack.supportsEnchantment((Holder)(enchantment = getter.getOrThrow(e)))) continue;
                for (Object2IntMap.Entry idk : stack.getAllEnchantments(getter).entrySet()) {
                    if (Enchantment.areCompatible((Holder)((Holder)idk.getKey()), (Holder)enchantment)) continue;
                    continue block0;
                }
                int maxLevel = ((Enchantment)enchantment.value()).getMaxLevel();
                stack.enchant((Holder)enchantment, maxLevel == 1 ? maxLevel : random.nextInt(1, maxLevel));
            }
        }
    }

    public class Manager {
        public Manager(ScalableReward this$0) {
        }

        public static List<ItemStack> getLoot(ServerLevel level, ResourceKey<ScalableReward> key, int quality) {
            RandomSource random = level.getRandom();
            HolderLookup.RegistryLookup registry = level.getServer().registryAccess().lookupOrThrow(WetlandWhimsyRegisters.SCALABLE_REWARD);
            Optional opt = registry.get(key);
            if (opt.isEmpty()) {
                WetlandWhimsy.LOGGER.error("ScalableReward " + String.valueOf(key.location()) + " not found!");
                return List.of();
            }
            ScalableReward scalableReward = (ScalableReward)((Holder.Reference)opt.get()).value();
            ArrayList<Loot> rewards = new ArrayList<Loot>(scalableReward.rewards);
            ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
            int maxWeight = 0;
            for (Loot reward : rewards) {
                maxWeight += reward.weight().intValue();
            }
            int dropCount = Math.min(random.nextInt(random.nextInt(1, ++quality), quality), scalableReward.max_drops);
            for (int i = 0; i < dropCount; ++i) {
                loot.add(Manager.getStack(level, rewards, quality, maxWeight));
            }
            return loot;
        }

        private static ItemStack getStack(ServerLevel level, List<Loot> rewards, int quality, int maxWeight) {
            ArrayList<Loot> choices = new ArrayList<Loot>();
            block0: for (int i = 0; i < quality - 1; ++i) {
                int rand = level.getRandom().nextInt(0, maxWeight);
                int cursor = 0;
                for (Loot choice : rewards) {
                    if ((cursor += choice.weight().intValue()) < rand) continue;
                    choices.add(choice);
                    continue block0;
                }
            }
            int choiceWeight = Integer.MAX_VALUE;
            Loot toReturn = null;
            for (Loot choice : choices) {
                if (choice.weight() > choiceWeight) continue;
                choiceWeight = choice.weight();
                toReturn = choice;
            }
            rewards.remove(toReturn);
            return toReturn == null ? ItemStack.EMPTY : toReturn.getItem(level, quality);
        }
    }
}

