/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.sludgecharge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.sludgecharge.SludgeChargeModel;
import uwu.juni.wetland_whimsy.content.entities.SludgeChargeEntity;

@ParametersAreNonnullByDefault
public class SludgeChargeRenderer
extends EntityRenderer<SludgeChargeEntity> {
    private static final double MIN_CAMERA_DISTANCE_SQUARED = Mth.square((float)3.5f);
    private static final ResourceLocation RLOC = WetlandWhimsy.rLoc("textures/entity/sludge_charge.png");
    private SludgeChargeModel model;

    public SludgeChargeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SludgeChargeModel(context.bakeLayer(SludgeChargeModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(SludgeChargeEntity entity) {
        return RLOC;
    }

    public void render(SludgeChargeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entity) < MIN_CAMERA_DISTANCE_SQUARED)) {
            VertexConsumer vcon = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)RLOC));
            float rot = Mth.lerp((float)partialTick, (float)entity.getOldVRot(), (float)entity.getVRot());
            poseStack.mulPose(Axis.XP.rotationDegrees(rot));
            poseStack.mulPose(Axis.YP.rotationDegrees(rot));
            this.model.renderToBuffer(poseStack, vcon, packedLight, OverlayTexture.NO_OVERLAY);
            super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }
}

