/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.infectedspider;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.infectedspider.InfectedSpiderAnimations;
import uwu.juni.wetland_whimsy.content.entities.InfectedSpiderEntity;

@ParametersAreNonnullByDefault
public class InfectedSpiderModel<T extends InfectedSpiderEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("infected_spider"), "main");
    private final ModelPart model_base;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart mushrooms;
    private final ModelPart left_legs;
    private final ModelPart front;
    private final ModelPart center;
    private final ModelPart back;
    private final ModelPart right_legs;
    private final ModelPart front2;
    private final ModelPart center2;
    private final ModelPart back2;

    public InfectedSpiderModel(ModelPart root) {
        this.model_base = root.getChild("model_base");
        this.head = this.model_base.getChild("head");
        this.tail = this.model_base.getChild("tail");
        this.mushrooms = this.tail.getChild("mushrooms");
        this.left_legs = this.model_base.getChild("left_legs");
        this.front = this.left_legs.getChild("front");
        this.center = this.left_legs.getChild("center");
        this.back = this.left_legs.getChild("back");
        this.right_legs = this.model_base.getChild("right_legs");
        this.front2 = this.right_legs.getChild("front2");
        this.center2 = this.right_legs.getChild("center2");
        this.back2 = this.right_legs.getChild("back2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition model_base = partdefinition.addOrReplaceChild("model_base", CubeListBuilder.create().texOffs(56, 32).addBox(-3.0f, -5.0f, -9.0f, 6.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)5.0f));
        PartDefinition head = model_base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 64).addBox(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.3f)).texOffs(56, 50).addBox(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.0f));
        PartDefinition tail = model_base.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -14.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition mushrooms = tail.addOrReplaceChild("mushrooms", CubeListBuilder.create().texOffs(0, 32).addBox(-14.0f, -14.0f, 3.0f, 28.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-14.0f, -14.0f, 13.0f, 28.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shroom_cross_2_r1 = mushrooms.addOrReplaceChild("shroom_cross_2_r1", CubeListBuilder.create().texOffs(32, 64).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-14.0f, (float)11.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition shroom_cross_1_r1 = mushrooms.addOrReplaceChild("shroom_cross_1_r1", CubeListBuilder.create().texOffs(32, 64).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-14.0f, (float)11.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition left_legs = model_base.addOrReplaceChild("left_legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front = left_legs.addOrReplaceChild("front", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front_r1 = front.addOrReplaceChild("front_r1", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-7.0f, (float)0.0f, (float)0.2618f, (float)0.48f));
        PartDefinition center = left_legs.addOrReplaceChild("center", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition center_r1 = center.addOrReplaceChild("center_r1", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition back = left_legs.addOrReplaceChild("back", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition back_r1 = back.addOrReplaceChild("back_r1", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.48f));
        PartDefinition right_legs = model_base.addOrReplaceChild("right_legs", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition front2 = right_legs.addOrReplaceChild("front2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition front_r2 = front2.addOrReplaceChild("front_r2", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-7.0f, (float)0.0f, (float)0.2618f, (float)0.48f));
        PartDefinition center2 = right_legs.addOrReplaceChild("center2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition center_r2 = center2.addOrReplaceChild("center_r2", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition back2 = right_legs.addOrReplaceChild("back2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition back_r2 = back2.addOrReplaceChild("back_r2", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.48f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(InfectedSpiderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(InfectedSpiderAnimations.INFECTED_SPIDER_WALK, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        this.animate(entity.idleAnimationState, InfectedSpiderAnimations.INFECTED_SPIDER_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.model_base;
    }

    public void prepareMobModel(InfectedSpiderEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.mushrooms.visible = !entity.isSheared();
    }
}

