/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.filth;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.filth.FilthAnimations;
import uwu.juni.wetland_whimsy.content.entities.FilthEntity;

@ParametersAreNonnullByDefault
public class FilthModel<T extends FilthEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("filth"), "main");
    private final ModelPart model_base;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;

    public FilthModel(ModelPart root) {
        this.model_base = root.getChild("model_base");
        this.left_arm = this.model_base.getChild("left_arm");
        this.right_arm = this.model_base.getChild("right_arm");
        this.body = this.model_base.getChild("body");
        this.head = this.body.getChild("head");
        this.tail = this.model_base.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition model_base = partdefinition.addOrReplaceChild("model_base", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_arm = model_base.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_arm = model_base.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition body = model_base.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 18).addBox(-7.0f, -10.0f, -1.0f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)7.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition spine_r1 = body.addOrReplaceChild("spine_r1", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition tail = model_base.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(2, 16).addBox(-1.0f, -0.1f, -2.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)13.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(FilthEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(FilthAnimations.WALK, limbSwing, limbSwingAmount, 3.5f, 2.5f);
        this.animate(entity.idleAnimationState, FilthAnimations.IDLE, ageInTicks);
        this.animate(entity.attackAnimationState, FilthAnimations.ATTACK, ageInTicks, 0.75f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.model_base;
    }
}

