/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.data.spawner.SpawnerData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public class SpawnerCommand
extends Command {
    private SpawnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"spawner").then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"parameter", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(List.of("Delay", "MinSpawnDelay", "MaxSpawnDelay", "SpawnCount", "MaxNearbyEntities", "RequiredPlayerRange", "SpawnRange"), (SuggestionsBuilder)builder)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> SpawnerCommand.setSpawnerValue((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"parameter"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))));
    }

    private static int setSpawnerValue(CommandSourceStack context, BlockPos blockPos, String parameter, int value) {
        CompoundTag spawnerData;
        SpawnerBlockEntity spawnerBlockEntity;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(blockPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerData = spawnerBlockEntity.getSpawner().save(new CompoundTag());
        } else if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity spawnerBlockEntity2 = (EasyNPCSpawnerBlockEntity)blockEntity;
            spawnerData = spawnerBlockEntity2.getSpawner().save(new CompoundTag());
        } else {
            return SpawnerCommand.sendFailureMessage(context, "No valid spawner found at " + String.valueOf(blockPos));
        }
        if (!SpawnerData.setSpawnerValue(spawnerData, parameter, (short)value)) {
            return SpawnerCommand.sendFailureMessage(context, "Invalid parameter " + parameter + " for spawner at " + String.valueOf(blockPos));
        }
        if (blockEntity instanceof SpawnerBlockEntity) {
            spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.getSpawner().load((Level)context.getLevel(), spawnerBlockEntity.getBlockPos(), spawnerData);
            spawnerBlockEntity.setChanged();
        } else if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity spawnerBlockEntity3 = (EasyNPCSpawnerBlockEntity)blockEntity;
            spawnerBlockEntity3.getSpawner().load((Level)context.getLevel(), spawnerBlockEntity3.getBlockPos(), spawnerData);
            spawnerBlockEntity3.setChanged();
        }
        return SpawnerCommand.sendSuccessMessage(context, "Adjusted spawner data " + String.valueOf(spawnerData) + " for spawner at " + String.valueOf(blockPos));
    }
}

