/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RespawnHandler;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class RespawnCommand
extends Command {
    private RespawnCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"respawn").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).executes(context -> RespawnCommand.respawn((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<CommandSourceStack>)context, "npc_targets"))));
    }

    private static int respawn(CommandSourceStack context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int respawnedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                if (!RespawnHandler.respawnNPC(easyNPC, context.getLevel())) continue;
                ++respawnedEntities;
                continue;
            }
            RespawnCommand.sendFailureMessage(context, "You are not allowed to respawn the Easy NPC " + String.valueOf(uuid) + " !");
        }
        if (respawnedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return RespawnCommand.sendSuccessMessage(context, "Respawn Easy NPC " + easyNPC.getEntity().getDisplayName().getString() + " !");
        }
        if (respawnedEntities > 1) {
            return RespawnCommand.sendSuccessMessage(context, "Respawned " + respawnedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return RespawnCommand.sendFailureMessage(context, "Nothing to respawn!");
    }
}

