/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.arguments.EntityTypeArgument;
import de.markusbordihn.easynpc.commands.suggestion.RenderTypeSuggestions;
import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import de.markusbordihn.easynpc.handler.RenderHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class RenderCommand
extends Command {
    private RenderCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"render").requires(commandSource -> commandSource.hasPermission(0))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(((LiteralArgumentBuilder)Commands.literal((String)"type").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests(RenderTypeSuggestions::suggest).executes(context -> RenderCommand.setRenderType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), RenderType.get(StringArgumentType.getString((CommandContext)context, (String)"type")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"model").requires(commandSourceStack -> commandSourceStack.hasPermission(0))).then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(context -> RenderCommand.setRenderEntityType((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)context, "entity")))))));
    }

    private static int setRenderType(CommandSourceStack context, EasyNPC<?> easyNPC, RenderType renderType) {
        if (easyNPC == null || renderType == null) {
            return 0;
        }
        if (!RenderHandler.setRenderType(easyNPC, renderType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render type " + String.valueOf((Object)renderType) + " for EasyNPC " + String.valueOf(easyNPC));
        }
        return RenderCommand.sendSuccessMessage(context, "Set render type " + String.valueOf((Object)renderType) + " for EasyNPC " + String.valueOf(easyNPC));
    }

    private static int setRenderEntityType(CommandSourceStack context, EasyNPC<?> easyNPC, EntityType<? extends Entity> entityType) {
        if (easyNPC == null || entityType == null) {
            return 0;
        }
        if (!RenderCommand.isDopplerNPC(easyNPC)) {
            return RenderCommand.sendFailureMessage(context, "Custom models can only be set on Doppler NPCs. Current NPC type: " + easyNPC.getEntity().getType().getDescriptionId());
        }
        if (!RenderHandler.setRenderEntity(easyNPC, entityType)) {
            return RenderCommand.sendFailureMessage(context, "Failed to set render entity " + String.valueOf(entityType) + " for EasyNPC " + String.valueOf(easyNPC));
        }
        return RenderCommand.sendSuccessMessage(context, "Set render entity " + String.valueOf(entityType) + " for EasyNPC with UUID " + String.valueOf(easyNPC.getEntityUUID()));
    }

    private static boolean isDopplerNPC(EasyNPC<?> easyNPC) {
        ConfigurationDataCapable configurable;
        return easyNPC instanceof ConfigurationDataCapable && (configurable = (ConfigurationDataCapable)easyNPC).getConfigurationData() == ConfigurationData.DOPPLER;
    }
}

