/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.handler.OwnerHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class OwnerCommand
extends Command {
    private static final String EASY_NPC_PREFIX = "EasyNPC ";

    private OwnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"owner").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> OwnerCommand.setOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), EntityArgument.getPlayer((CommandContext)context, (String)"player"))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> OwnerCommand.getOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntity((CommandContext<CommandSourceStack>)context, "npc_target")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> OwnerCommand.removeOwner((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target")))));
    }

    private static int setOwner(CommandSourceStack context, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        if (easyNPC == null || serverPlayer == null) {
            return 0;
        }
        if (!OwnerHandler.setOwner(easyNPC, (LivingEntity)serverPlayer)) {
            OwnerCommand.sendFailureMessage(context, "Failed to set owner for " + String.valueOf(easyNPC));
        }
        return OwnerCommand.sendSuccessMessage(context, "Owner of " + String.valueOf(easyNPC) + " was changed to " + String.valueOf(serverPlayer));
    }

    private static int getOwner(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        if (ownerData == null) {
            return OwnerCommand.sendFailureMessageNoOwnerData(context, easyNPC);
        }
        return OwnerCommand.sendSuccessMessage(context, EASY_NPC_PREFIX + String.valueOf(easyNPC.getEntityUUID()) + " is owned by " + String.valueOf(ownerData.getOwner()));
    }

    private static int removeOwner(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        if (!OwnerHandler.removeOwner(easyNPC)) {
            return OwnerCommand.sendFailureMessage(context, "Failed to remove owner for " + String.valueOf(easyNPC));
        }
        return OwnerCommand.sendSuccessMessage(context, "Owner of " + String.valueOf(easyNPC) + " was removed.");
    }
}

