/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item;

import de.markusbordihn.easynpc.component.DataComponents;
import de.markusbordihn.easynpc.data.test.TestItemData;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomDataTestItem
extends Item {
    public static final String ID = "custom_data_test";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public CustomDataTestItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        itemStack.set(DataComponents.TEST_ITEM_DATA, (Object)TestItemData.DEFAULT);
        return itemStack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TestItemData testItemData = TestItemData.get(itemStack);
            if (testItemData == null) {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u274c ERROR: Custom data is missing or incomplete!").withStyle(ChatFormatting.RED));
                log.error("Custom data test item used by {} but data is missing.", (Object)serverPlayer.getName().getString());
            } else {
                String quote = testItemData.quote();
                int numberValue = testItemData.numberValue();
                int powerLevel = testItemData.powerLevel();
                int usageCounter = testItemData.usageCounter();
                TestItemData updatedData = testItemData.withIncrementedUsageCounter();
                itemStack.set(DataComponents.TEST_ITEM_DATA, (Object)updatedData);
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u2713 Custom data verified successfully!").withStyle(ChatFormatting.GREEN));
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("Quote: \"" + quote + "\"")).withStyle(ChatFormatting.AQUA));
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("Number Value: " + numberValue)).withStyle(ChatFormatting.YELLOW));
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("Power Level: " + powerLevel)).withStyle(ChatFormatting.LIGHT_PURPLE));
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("Usage Count: " + (usageCounter + 1))).withStyle(ChatFormatting.GOLD));
                log.info("Custom data test item verified by {}. Quote: {}, Number: {}, Power: {}, Usage: {}", (Object)serverPlayer.getName().getString(), (Object)quote, (Object)numberValue, (Object)powerLevel, (Object)(usageCounter + 1));
            }
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.custom_data_test"));
        TestItemData testItemData = TestItemData.get(itemStack);
        if (testItemData != null) {
            tooltipList.add((Component)Component.literal((String)""));
            tooltipList.add((Component)Component.literal((String)"Custom Data Present:").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            tooltipList.add((Component)Component.literal((String)("Quote: \"" + testItemData.quote() + "\"")).withStyle(ChatFormatting.AQUA));
            tooltipList.add((Component)Component.literal((String)("Number: " + testItemData.numberValue())).withStyle(ChatFormatting.YELLOW));
            tooltipList.add((Component)Component.literal((String)("Power: " + testItemData.powerLevel())).withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltipList.add((Component)Component.literal((String)("Times Used: " + testItemData.usageCounter())).withStyle(ChatFormatting.GOLD));
        } else {
            tooltipList.add((Component)Component.literal((String)""));
            tooltipList.add((Component)Component.literal((String)"\u26a0 No custom data").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        }
    }
}

