/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.gametest;

import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.gametest.GameTestHelpers;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.menu.dialog.DialogMenuHandler;
import java.util.UUID;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.Vec3;

public class DialogScreenTestHelper {
    private DialogScreenTestHelper() {
    }

    public static UUID mockOpenDialog(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, MenuType<? extends DialogMenu> menuType) {
        MenuProvider menuProvider = DialogMenuHandler.getMenuProvider(easyNPC, menuType, new ScreenData(easyNPC.getEntityUUID(), easyNPC.getEasyNPCDialogData().getDialogDataSet().getDialogsByLabel().stream().findFirst().map(DialogDataEntry::getId).orElse(null)));
        UUID menuId = MenuManager.registerMenu(easyNPC.getEntityUUID(), menuProvider, serverPlayer);
        MenuManager.openMenu(menuId, serverPlayer);
        return menuId;
    }

    public static void testDialogScreen(GameTestHelper helper, DialogDataSet dialogDataSet, EntityType<? extends PathfinderMob> npcEntityType, MenuType<? extends DialogMenu> menuType) {
        ServerPlayer serverPlayer = GameTestHelpers.mockServerPlayer(helper, new Vec3(1.0, 2.0, 1.0));
        EasyNPC<?> easyNPC = GameTestHelpers.mockEasyNPC(helper, npcEntityType, new Vec3(2.0, 2.0, 2.0));
        if (serverPlayer.hasContainerOpen()) {
            serverPlayer.closeContainer();
        }
        GameTestHelpers.assertNotNull(helper, "DialogDataSet is null!", dialogDataSet);
        easyNPC.getEasyNPCDialogData().setDialogDataSet(dialogDataSet);
        GameTestHelpers.assertNotNull(helper, "DialogData is null!", easyNPC.getEasyNPCDialogData());
        UUID dialogId = DialogScreenTestHelper.mockOpenDialog(serverPlayer, easyNPC, menuType);
        GameTestHelpers.assertNotNull(helper, "DialogId is null!", dialogId);
        GameTestHelpers.assertTrue(helper, "Dialog Screen " + String.valueOf(menuType) + " is not open!", serverPlayer.containerMenu instanceof DialogMenu);
        GameTestHelpers.assertEquals(helper, "Wrong Dialog type! Expected: " + String.valueOf(menuType) + " but got: " + String.valueOf(serverPlayer.containerMenu.getType()), menuType, serverPlayer.containerMenu.getType());
    }
}

