/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.variant.HumanoidSlimSkinVariant;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PathfinderMobRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class HumanoidSlimNPC
extends PathfinderMobRaw
implements StandardEasyNPC<PathfinderMobRaw> {
    public static final String ID = "humanoid_slim";

    public HumanoidSlimNPC(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, HumanoidSlimSkinVariant.ALEX);
    }

    public HumanoidSlimNPC(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.HUMANOID_SLIM;
    }

    @Override
    public Enum<?>[] getSkinVariantTypes() {
        return HumanoidSlimSkinVariant.values();
    }

    @Override
    public Enum<?> getDefaultSkinVariantType() {
        return HumanoidSlimSkinVariant.ALEX;
    }

    @Override
    public Enum<?> getSkinVariantType(String name) {
        try {
            return HumanoidSlimSkinVariant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultSkinVariantType();
        }
    }

    @Override
    public boolean canUseArmor() {
        return true;
    }

    @Override
    public ConfigurationData getConfigurationData() {
        return ConfigurationData.HUMANOID;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.PLAYER_DEATH);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.PLAYER_HURT);
        soundDataSet.addDefaultSound(SoundType.EAT, SoundEvents.GENERIC_EAT);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }
}

