/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogActionExecutor {
    protected static final Logger log = LogManager.getLogger(DialogActionExecutor.class);

    private DialogActionExecutor() {
    }

    public static void openDefaultDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer, DialogDataCapable<?> dialogData) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        if (dialogData != null) {
            dialogData.openDefaultDialog(serverPlayer);
        } else {
            log.error("No dialog data found for action {}", (Object)actionDataEntry);
            serverPlayer.closeContainer();
        }
    }

    public static void openNamedDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer, DialogDataCapable<?> dialogData) {
        DialogDataCapable<Object> targetDialogData;
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        if (actionDataEntry.targetUUID() == null) {
            targetDialogData = dialogData;
        } else {
            EasyNPC<?> targetNpc = DialogActionExecutor.findEasyNPCByUuid(serverPlayer.serverLevel(), actionDataEntry.targetUUID());
            if (targetNpc == null) {
                log.error("Target NPC with UUID {} not found", (Object)actionDataEntry.targetUUID());
                serverPlayer.closeContainer();
                return;
            }
            targetDialogData = targetNpc.getEasyNPCDialogData();
            if (targetDialogData == null) {
                log.error("No dialog data found for NPC {}", (Object)actionDataEntry.targetUUID());
                serverPlayer.closeContainer();
                return;
            }
        }
        String dialogLabel = actionDataEntry.command();
        if (ActionValidator.validateNamedDialog(targetDialogData, dialogLabel)) {
            targetDialogData.openDialog(serverPlayer, targetDialogData.getDialogId(dialogLabel));
        } else {
            log.error("Unknown dialog label {} for action {}", (Object)dialogLabel, (Object)actionDataEntry);
            serverPlayer.closeContainer();
        }
    }

    private static EasyNPC<?> findEasyNPCByUuid(ServerLevel level, UUID uuid) {
        EasyNPC easyNPC;
        Entity entity = level.getEntity(uuid);
        return entity instanceof EasyNPC ? (easyNPC = (EasyNPC)entity) : null;
    }
}

