/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.Objects;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisibilityHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final double DEFAULT_NAME_VISIBILITY_RANGE = 16.0;

    private VisibilityHandler() {
    }

    public static boolean handleIsInvisible(EasyNPC<?> easyNPC, boolean isInvisible) {
        if (easyNPC.getLivingEntity().hasEffect(MobEffects.GLOWING)) {
            return false;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData != null && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        return isInvisible;
    }

    public static boolean handleIsInvisibleToPlayer(EasyNPC<?> easyNPC, Player player, boolean isInvisibleToPlayers) {
        boolean visibleToTeamEnabled;
        boolean visibleToOwnerEnabled;
        if (easyNPC.getLivingEntity().hasEffect(MobEffects.GLOWING)) {
            return false;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            return isInvisibleToPlayers;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        boolean isOwner = ownerData != null && ownerData.hasNPCOwner() && Objects.equals(ownerData.getOwnerUUID(), player.getUUID());
        boolean bl = visibleToOwnerEnabled = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_OWNER) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_OWNER);
        if (isOwner && visibleToOwnerEnabled) {
            return false;
        }
        PlayerTeam playerTeam = player.getTeam();
        PlayerTeam npcTeam = easyNPC.getLivingEntity().getTeam();
        boolean bl2 = visibleToTeamEnabled = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_TEAM) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_TEAM);
        if (npcTeam != null && playerTeam != null && npcTeam.equals(playerTeam) && visibleToTeamEnabled && npcTeam.canSeeFriendlyInvisibles()) {
            return false;
        }
        boolean isCreativeMode = player.isCreative();
        boolean isSpectatorMode = player.isSpectator();
        boolean isStandardMode = !isCreativeMode && !isSpectatorMode;
        boolean gameModeVisibilitySet = false;
        boolean visibleInCurrentGameMode = false;
        if (isCreativeMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE);
        } else if (isSpectatorMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR);
        } else if (isStandardMode && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD)) {
            gameModeVisibilitySet = true;
            visibleInCurrentGameMode = displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD);
        }
        if (gameModeVisibilitySet && visibleInCurrentGameMode) {
            return false;
        }
        long dayTime = player.level().getDayTime() % 24000L;
        boolean isDayTime = dayTime >= 1000L && dayTime <= 13000L;
        boolean isNightTime = !isDayTime;
        boolean visibleAtDaySet = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_DAY);
        boolean visibleAtNightSet = displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT);
        if (isDayTime && visibleAtDaySet || isNightTime && visibleAtNightSet) {
            boolean visibleAtCurrentTime;
            boolean bl3 = visibleAtCurrentTime = isDayTime ? displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_DAY) : displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT);
            if (visibleAtCurrentTime) {
                return false;
            }
            if (!gameModeVisibilitySet) {
                return true;
            }
        }
        if (gameModeVisibilitySet && !visibleInCurrentGameMode) {
            return true;
        }
        return isDayTime && !visibleAtDaySet && visibleAtNightSet || isNightTime && !visibleAtNightSet && visibleAtDaySet;
    }

    public static boolean handleIsCustomNameVisible(EasyNPC<?> easyNPC, boolean isCustomNameVisible) {
        return VisibilityHandler.evaluateNameVisibility(easyNPC, null, isCustomNameVisible);
    }

    public static boolean handleIsCustomNameVisibleToPlayer(EasyNPC<?> easyNPC, Player player, boolean isCustomNameVisible) {
        return VisibilityHandler.evaluateNameVisibility(easyNPC, player, isCustomNameVisible);
    }

    private static boolean evaluateNameVisibility(EasyNPC<?> easyNPC, Player player, boolean fallbackVisibility) {
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
        if (!displayAttributeData.hasDisplayAttribute(DisplayAttributeType.NAME_VISIBILITY)) {
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
        String nameVisibilityString = displayAttributeData.getDisplayStringAttribute(DisplayAttributeType.NAME_VISIBILITY);
        try {
            NameVisibilityType nameVisibilityType = NameVisibilityType.valueOf(nameVisibilityString);
            return VisibilityHandler.evaluateNameVisibilityType(easyNPC, player, nameVisibilityType, fallbackVisibility);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid name visibility type: {}", easyNPC, (Object)nameVisibilityString);
            return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
        }
    }

    private static boolean evaluateNameVisibilityType(EasyNPC<?> easyNPC, Player player, NameVisibilityType nameVisibilityType, boolean fallbackVisibility) {
        switch (nameVisibilityType) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case NEAR: {
                if (!easyNPC.getEntity().hasCustomName()) {
                    return false;
                }
                if (player != null) {
                    return easyNPC.getEntity().distanceToSqr((Entity)player) <= 256.0;
                }
                return fallbackVisibility;
            }
        }
        return VisibilityHandler.hasCustomNameFallback(easyNPC, fallbackVisibility);
    }

    private static boolean hasCustomNameFallback(EasyNPC<?> easyNPC, boolean fallbackVisibility) {
        return easyNPC.getEntity().hasCustomName() && fallbackVisibility;
    }
}

