/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ItemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InteractionHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private InteractionHandler() {
    }

    public static InteractionResult handleMobInteraction(EasyNPC<?> easyNPC, Player player, InteractionHand hand) {
        ActionEventDataCapable actionEventData;
        ServerPlayer serverPlayer;
        block12: {
            block11: {
                if (!(player instanceof ServerPlayer)) break block11;
                serverPlayer = (ServerPlayer)player;
                if (hand == InteractionHand.MAIN_HAND) break block12;
            }
            return InteractionResult.PASS;
        }
        ConfigurationDataCapable configurationData = easyNPC.getEasyNPCConfigurationData();
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        boolean isOwnerOrCreative = serverPlayer.isCreative() || ownerData.isNPCOwner(serverPlayer);
        ItemStack handItemStack = player.getItemInHand(hand);
        if (!handItemStack.isEmpty()) {
            Item easyNPCWand;
            Item handItem = handItemStack.getItem();
            if (handItem.equals(easyNPCWand = ItemUtils.getEasyNPCWandItem())) {
                return InteractionResult.PASS;
            }
            Item moveEasyNPCItem = ItemUtils.getMoveEasyNPCItem();
            if (handItem.equals(moveEasyNPCItem)) {
                return InteractionResult.PASS;
            }
            if ("armourers_workshop".equals(BuiltInRegistries.ITEM.getKey((Object)handItem).getNamespace())) {
                if (isOwnerOrCreative) {
                    SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
                    if (skinData.getSkinModel().hasArmourersWorkshopSupport()) {
                        log.debug("Ignore event for Armourer's Workshop Item for {} ...", easyNPC);
                        return InteractionResult.PASS;
                    }
                    serverPlayer.sendSystemMessage((Component)TextComponent.getTranslatedText("armourers_workshop.no_support", skinData.getSkinModel().name(), easyNPC.toString()));
                } else {
                    log.debug("{} has no permissions to use Armourer's Workshop Item for {} ...", (Object)serverPlayer, easyNPC);
                    return InteractionResult.CONSUME;
                }
            }
        }
        if ((actionEventData = easyNPC.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_INTERACTION, serverPlayer);
        }
        return InteractionResult.PASS;
    }
}

